(function ($, Drupal, drupalSettings) {

  function initSlickSliders(context) {
    if (!drupalSettings.slickProCustomizer) return;

    drupalSettings.slickProCustomizer.forEach(function (config) {
      $(config.selector, context).once('slickInit').each(function () {
        const $slider = $(this);

        // Remove empty slides
        $slider.children().filter(function () {
          return $(this).is(':empty');
        }).remove();

        // Use custom arrows if they exist; otherwise let Slick generate default arrows
        const prevArrow = config.arrows && config.custom_prev_arrow && $(config.custom_prev_arrow).length
          ? $(config.custom_prev_arrow)
          : undefined;

        const nextArrow = config.arrows && config.custom_next_arrow && $(config.custom_next_arrow).length
          ? $(config.custom_next_arrow)
          : undefined;

        $slider.slick({
          slidesToShow: parseInt(config.slides_desktop, 10) || 3,
          slidesToScroll: 1,
          autoplay: !!config.autoplay,
          autoplaySpeed: parseInt(config.autoplay_speed, 10) || 3000,
          speed: parseInt(config.speed, 10) || 500,
          arrows: !!config.arrows,
          prevArrow: prevArrow,
          nextArrow: nextArrow,
          dots: !!config.dots,
          infinite: !!config.infinite,
          centerMode: !!config.center_mode,
          centerPadding: $(window).width() < 768
            ? config.center_padding_mobile || '30px'
            : config.center_padding_desktop || '60px',
          initialSlide: 0,
          responsive: [
            {
              breakpoint: 768,
              settings: {
                slidesToShow: parseInt(config.slides_mobile, 10) || 1,
                centerPadding: config.center_padding_mobile || '30px',
              },
            },
          ],
        });
      });
    });
  }

  Drupal.behaviors.slickProCustomizer = {
    attach: function (context) {
      // Initialize on full page load
      $(window).on('load', function () {
        initSlickSliders(context);
      });

      // Initialize after any AJAX completes
      $(document).ajaxComplete(function () {
        initSlickSliders(context);
      });
    },
  };

})(jQuery, Drupal, drupalSettings);
