(function (Drupal, once) {
  Drupal.behaviors.fancyboxGallery = {
    attach(context) {

      // Inicializa Fancybox solo una vez
      once('fancybox-bind', '[data-fancybox]', context).forEach(() => {
        Fancybox.bind('[data-fancybox]', {
          Thumbs: {
            autoStart: true,
          },
        });
      });

      // BOTÓN "Mostrar más imágenes"
      once('fancybox-button', '.open-gallery', context).forEach((button) => {
        button.addEventListener('click', (e) => {
          e.preventDefault();

          const galleryId = button.dataset.gallery;

          Fancybox.show(
            Fancybox.getInstance()?.group ||
            Array.from(
              document.querySelectorAll(`[data-fancybox="${galleryId}"]`)
            ).map((el) => ({
              src: el.getAttribute('href'),
              type: 'image',
              caption: el.dataset.caption || '',
            })),
            {
              Thumbs: {
                autoStart: true,
              },
            }
          );
        });
      });
    }
  };
})(Drupal, once);
