(function () {
  const sliderInstances = {};

  function initSlider(slider_id) {
    const slidesContainer = document.getElementById('slides-' + slider_id);
    const slides = slidesContainer.querySelectorAll('.slide-module');
    const thumbnailsContainer = document.getElementById('thumbnails-' + slider_id);
    let currentIndex = 0;

    slides.forEach(slide => slide.style.flex = '0 0 100%');

    const thumbDivs = thumbnailsContainer.querySelectorAll('.thumbnail');
    thumbDivs.forEach((thumb, index) => {
      thumb.addEventListener('click', function (e) {
        // 👉 Si el click vino de un <a data-fancybox>, no muevas el slider
        if (e.target.closest('a[data-fancybox]')) return;

        currentIndex = index;
        updateSlider();
      });
    });

    function updateSlider() {
      const offset = -currentIndex * 100;
      slidesContainer.style.transform = 'translateX(' + offset + '%)';
      thumbDivs.forEach((thumb, index) => {
        thumb.classList.toggle('active', index === currentIndex);
      });
    }

    sliderInstances[slider_id] = {
      next() {
        currentIndex = (currentIndex + 1) % slides.length;
        updateSlider();
      },
      prev() {
        currentIndex = (currentIndex - 1 + slides.length) % slides.length;
        updateSlider();
      }
    };

    updateSlider();
  }

  document.addEventListener('DOMContentLoaded', function () {
    const sliders = document.querySelectorAll('[id^="slider-"]');
    sliders.forEach(function (slider) {
      const slider_id = slider.id.replace('slider-', '');
      initSlider(slider_id);
    });

    document.body.addEventListener('click', function (event) {
      const button = event.target.closest('[data-action][data-slider-id]');
      if (!button) return;

      const action = button.getAttribute('data-action');
      const slider_id = button.getAttribute('data-slider-id');

      const slider = sliderInstances[slider_id];
      if (!slider) return;

      if (action === 'next') {
        slider.next();
      } else if (action === 'prev') {
        slider.prev();
      }
    });
  });
})();


(function (Drupal) {
  Drupal.behaviors.sliderGalleryFancybox = {
    attach: function (context) {
      // Delegado: botón "+N images" abre Fancybox en el índice correcto.
      context.querySelectorAll('.open-modal-btn').forEach(function (btn) {
        if (btn.dataset.fancyboxBound) return; // prevenir doble binding
        btn.dataset.fancyboxBound = '1';

        btn.addEventListener('click', function (e) {
          e.preventDefault();
          const sliderId = btn.getAttribute('data-slider-id');
          const startIndex = parseInt(btn.getAttribute('data-start-index'), 10) || 0;

          // Recolectar todos los anchors del grupo
          const groupSelector = `[data-fancybox="gallery-${sliderId}"]`;
          const anchors = Array.from(document.querySelectorAll(groupSelector));

          if (!anchors.length) return;

          // Mapear a ítems Fancybox (href + optional caption/thumbnail si quisieras)
          const items = anchors.map(a => ({
            src: a.getAttribute('href'),
            type: 'image'
          }));

          // Abrir Fancybox empezando en la primera extra
          // (Fancybox 4 - UMD)
          if (window.Fancybox && typeof window.Fancybox.show === 'function') {
            window.Fancybox.show(items, {
              startIndex: startIndex,
              Thumbs: {autoStart: true}
              // Puedes agregar más opciones aquí
            });
          } else {
            // Fallback: intenta "clic" en el anchor correspondiente
            const target = anchors[startIndex] || anchors[0];
            target && target.click();
          }
        });
      });
    }
  };
})(Drupal);
