document.addEventListener('DOMContentLoaded', function() {
  console.log('Modal JS cargado!');

  // Abrir modal
  document.querySelectorAll('.open-modal-btn').forEach(function(btn) {
    btn.addEventListener('click', function() {
      var sliderId = btn.dataset.sliderId;
      document.getElementById('modal-' + sliderId).style.display = 'block';
    });
  });

  // Cerrar modal
  document.querySelectorAll('.close-modal').forEach(function(btn) {
    btn.addEventListener('click', function() {
      var sliderId = btn.dataset.sliderId;
      document.getElementById('modal-' + sliderId).style.display = 'none';
    });
  });

  // Cerrar clic fuera
  document.querySelectorAll('.image-modal').forEach(function(modal) {
    modal.addEventListener('click', function(e) {
      if (e.target === modal) {
        modal.style.display = 'none';
      }
    });
  });

  // Slider interno
  var currentSlides = {}; // Guarda slide actual por sliderId

  document.querySelectorAll('.modal-slider').forEach(function(slider) {
    var sliderId = slider.dataset.sliderId;
    currentSlides[sliderId] = 0; // empieza en la primera imagen
  });

  function showSlide(sliderId, index) {
    var slides = document.querySelectorAll('#modal-' + sliderId + ' .modal-slide');
    if (slides.length === 0) return;

    // Asegura que el índice esté en rango
    if (index >= slides.length) index = 0;
    if (index < 0) index = slides.length - 1;
    currentSlides[sliderId] = index;

    slides.forEach(function(slide, i) {
      slide.style.display = (i === index) ? 'block' : 'none';
    });
  }

  // Botón siguiente
  document.querySelectorAll('.modal-next').forEach(function(btn) {
    btn.addEventListener('click', function() {
      var sliderId = btn.dataset.sliderId;
      showSlide(sliderId, currentSlides[sliderId] + 1);
    });
  });

  // Botón anterior
  document.querySelectorAll('.modal-prev').forEach(function(btn) {
    btn.addEventListener('click', function() {
      var sliderId = btn.dataset.sliderId;
      showSlide(sliderId, currentSlides[sliderId] - 1);
    });
  });
});
