<?php

declare(strict_types=1);

namespace Drupal\slots_test\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Returns responses for Slots test routes.
 */
final class SlotsTwigTestController extends ControllerBase {

  /**
   * Builds the response.
   */
  public function __invoke(): array {
    $build['content'] = [
      '#theme' => 'slots_twig_test',
      '#cache' => [
        'max-age' => 0,
      ],
    ];

    return $build;
  }

}
