<?php

namespace Drupal\slots_twig\TwigExtension;

use Drupal\slots\SlotsServiceInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Slots twig extension.
 */
class SlotTwigExtension extends AbstractExtension {

  /**
   * Builds a SlotTwigExtension object.
   *
   * @param \Drupal\slots\SlotsServiceInterface $slotService
   *   The slots service.
   */
  public function __construct(
    protected readonly SlotsServiceInterface $slotService,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getFunctions() {
    return [
      new TwigFunction('slot',
        [$this->slotService, 'buildSlot'],
        ['is_safe' => ['html']],
      ),
    ];
  }

}
