<?php

declare(strict_types=1);

namespace Drupal\Tests\slots\Kernel;

use Drupal\field\Entity\FieldConfig;
use Drupal\block_content\Entity\BlockContent;
use Drupal\block_content\Entity\BlockContentType;
use Drupal\Tests\BrowserTestBase;

/**
 * Test the slots_twig module.
 *
 * @group slots
 */
final class SlotsTwigTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'slots',
    'slots_twig',
    'slots_test',
    'block',
    'block_content',
    'system',
    'user',
    'conditions',
    'conditions_field',
    'block_plugin_view_builder',
    'field',
    'json_field',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $admin_user = $this->drupalCreateUser(['administer site configuration']);
    $this->drupalLogin($admin_user);
  }

  /**
   * Test content is determined by SlotService::buildSlotContents() correctly.
   */
  public function testBuildSlotContents(): void {
    $this->drupalGet('/slots-test/slots-twig-test');
    $this->assertSession()->pageTextContains('Smoke test');

    // Create a block content type.
    BlockContentType::create([
      'id' => 'spiffy',
      'label' => 'Mucho spiffy',
      'description' => "Provides a block type that increases your site's spiffiness by up to 11%",
    ])->save();

    $fieldStorage = \Drupal::entityTypeManager()->getStorage('field_storage_config')->create([
      'field_name' => 'field_slots',
      'entity_type' => 'block_content',
      'type' => 'slots',
    ]);
    $fieldStorage->save();
    $field = FieldConfig::create([
      'field_storage' => $fieldStorage,
      'label' => 'Slots',
      'bundle' => 'spiffy',
      'description' => 'Description for slots',
      'required' => FALSE,
    ]);
    $field->save();

    // And a block content entity.
    $slot_content = BlockContent::create([
      'info' => 'Spiffy prototype',
      'type' => 'spiffy',
    ]);
    $slot_content->set('field_slots', [
      'condition_logic' => 'and',
      'group_condition_logic' => 'or',
      'value' => '{"9546f5e5-010a-4a5b-9a72-52fd020373a8":{"id":"slot","uuid":"9546f5e5-010a-4a5b-9a72-52fd020373a8","slot_id":"not_my_slot","negate":false,"context_mapping":{"slot_id":"@slots.context_provider:slot"}}}',
      'slots_status' => 1,
      'status' => 1,
    ]);
    $slot_content->save();

    $this->drupalGet('/slots-test/slots-twig-test');
    $this->assertSession()->pageTextNotContains('Slot wrapper is rendered');

    // And a block content entity.
    $slot_content = BlockContent::create([
      'info' => 'Spiffy prototype',
      'type' => 'spiffy',
    ]);
    $slot_content->set('field_slots', [
      'condition_logic' => 'and',
      'group_condition_logic' => 'or',
      'value' => '{"9546f5e5-010a-4a5b-9a72-52fd020373a9":{"id":"slot","uuid":"9546f5e5-010a-4a5b-9a72-52fd020373a9","slot_id":"my_slot","negate":false,"context_mapping":{"slot_id":"@slots.context_provider:slot"}}}',
      'slots_status' => 1,
      'status' => 1,
    ]);
    $slot_content->save();

    $this->drupalGet('/slots-test/slots-twig-test');
    $this->assertSession()->pageTextContains('Slot wrapper is rendered');
  }

}
