<?php

declare(strict_types=1);

namespace Drupal\slots\Plugin\Condition;

/**
 * Interface for the slots condition.
 */
interface SlotConditionInterface {

  /**
   * Get the weight of the condition.
   *
   * @return int
   *   The weight of the slots condition.
   */
  public function getWeight(): int;

  /**
   * Get the slot ID of the condition.
   *
   * @return string
   *   The slot ID of the slots condition.
   */
  public function getSlotId(): string;

}
