<?php

namespace Drupal\slots\Plugin\Field;

use Drupal\Component\Utility\SortArray;
use Drupal\Core\TypedData\ComputedItemListTrait;
use Drupal\dynamic_entity_reference\Plugin\Field\FieldType\DynamicEntityReferenceFieldItemList;

/**
 * Computed field item list for the slot content field.
 */
class ComputedSlotContentFieldItemList extends DynamicEntityReferenceFieldItemList {

  use ComputedItemListTrait;

  /**
   * Compute the list based on the matching slot content.
   */
  protected function computeValue() {
    if (!$this->getEntity()->isNew()) {
      // Load services statically until #2053415 lands.
      /** @var \Drupal\conditions\ConditionsServiceInterface $conditions_service */
      $conditions_service = \Drupal::service('conditions.service');
      /** @var \Drupal\conditions_field\ConditionsFieldServiceInterface $conditions_field_service */
      $conditions_field_service = \Drupal::service('slots.conditions_field.service');
      /** @var \Drupal\slots\SlotsServiceInterface $slots_service */
      $slots_service = \Drupal::service('slots.service');

      $list = [];
      foreach ($slots_service->getSlotEntityTypes() as $entity_type_id => $entity_type) {
        $items = $conditions_field_service->getItemsDataByConditionConfiguration(
          $entity_type_id,
          [
            'id' => 'slot',
            'slot_id' => $this->getEntity()->id(),
          ],
          [
            'status' => '1',
            'slots_status' => '1',
          ],
        );
        foreach ($items as $entity_id => $conditions_groups) {
          $conditions_service->initializeConditions($conditions_groups);
          $weight = $slots_service->getWeightByConditionGroups($conditions_groups, $this->getEntity()->id());
          $list[] = [
            'target_id' => $entity_id,
            'target_type' => $entity_type_id,
            'weight' => $weight,
          ];
        }
      }
      uasort($list, [SortArray::class, 'sortByWeightElement']);
      foreach ($list as $delta => $item) {
        $this->list[$delta] = $this->createItem($delta, $item);
      }
    }
  }

}
