<?php

declare(strict_types=1);

namespace Drupal\slots\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FormatterBase;
use Drupal\Component\Serialization\Json;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'Slot IDs' formatter.
 */
#[FieldFormatter(
  id: 'slot_ids',
  label: new TranslatableMarkup('Slot IDs'),
  field_types: [
    'slots',
  ],
)]
final class SlotIdsFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $slot_ids = [];
    $elements = [];
    foreach ($items as $delta => $item) {
      $conditions = Json::decode($item->value);
      foreach ($conditions as $condition) {
        if ($condition['id'] == 'slot') {
          $slot_ids[] = $condition['slot_id'];
        }
      }
      $elements[$delta] = ['#markup' => implode(',', $slot_ids)];
    }

    return $elements;

  }

}
