<?php

namespace Drupal\slots;

use Drupal\Core\Render\RenderableInterface;

/**
 * The slot renderable.
 */
class Slot implements RenderableInterface, \Countable {

  /**
   * Constructs a Slot object.
   *
   * @param array $build
   *   The slot placeholder.
   * @param int $count
   *   The number of content expected for this slot.
   */
  public function __construct(
    protected array $build,
    protected int $count,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function toRenderable(): array {
    return $this->build;
  }

  /**
   * {@inheritdoc}
   */
  public function count(): int {
    return $this->count;
  }

}
