<?php

namespace Drupal\slots;

use Drupal\views\EntityViewsData;
use Drupal\Core\Entity\EntityTypeInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides views integration for slots.
 */
class SlotsViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function __construct(protected readonly SlotsServiceInterface $slotsService, ...$args) {
    parent::__construct(...$args);
  }

  /**
   * {@inheritdoc}
   */
  public static function createInstance(ContainerInterface $container, EntityTypeInterface $entity_type) {
    return new static(
      $container->get('slots.service'),
      $entity_type,
      $container->get('entity_type.manager')->getStorage($entity_type->id()),
      $container->get('entity_type.manager'),
      $container->get('module_handler'),
      $container->get('string_translation'),
      $container->get('entity_field.manager'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getViewsData() {
    $data = parent::getViewsData();

    $base_table = $this->entityType->getDataTable();
    $data[$base_table]['content'] = [
      'title' => $this->t('Content'),
      'field' => [
        'id' => 'field',
        'default_formatter' => 'dynamic_entity_reference_label',
        'field_name' => 'content',
      ],
    ];

    foreach ($this->slotsService->getSlotEntityTypes() as $entity_type_id => $entity_type) {
      /** @var \Drupal\Core\Entity\EntityTypeInterface $entity_type */
      $entity_type = $this->entityTypeManager->getDefinition($entity_type_id);
      $table = $entity_type->getDataTable();
      $data[$table]['slot_id'] = [
        'title' => $this->t('Slot ID (all slot fields)'),
        'filter' => [
          'group' => $entity_type->getLabel(),
          'title' => $this->t('Slot ID (all slot fields)'),
          'help' => $this->t('Filter by slot ID'),
          'field' => 'id',
          'id' => 'slot_id_filter',
          'table' => $table,
          'entity_type' => $entity_type_id,
          'allow empty' => TRUE,
        ],
        'field' => [
          'title' => $this->t('Slot ID (all slot fields)'),
          'id' => 'slot_id',
        ],
        'real field' => 'id',
      ];
    }

    $entity_type = $this->entityTypeManager->getDefinition('slot');
    $table = $entity_type->getDataTable();
    $data[$table]['slot_bulk_form'] = [
      'title' => $this->t('Slot operations bulk form'),
      'help' => $this->t('Add a form element that lets you run operations on multiple slots.'),
      'field' => [
        'title' => $this->t('Slot operations bulk form'),
        'id' => 'slot_bulk_form',
      ],
      'real field' => 'id',
    ];

    return $data;
  }

}
