  <?php
  
  namespace Drupal\smssystem\Plugin\QueueWorker;
  
  use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
  use Drupal\Core\Queue\QueueWorkerBase;
  use Symfony\Component\DependencyInjection\ContainerInterface;
  use Drupal\smssystem\Services\SmsSend;
  
  /**
   * The SMS message processing logic.
   */
  abstract class SmsProcessing extends QueueWorkerBase implements ContainerFactoryPluginInterface {
  
    /**
     * The SMS Send service.
     *
     * @var \Drupal\smssystem\Services\SmsSend
     */
    protected SmsSend $smsSend;
    
    /**
     * Creates a new SmsProcessing instance.
     *
     * @param array $configuration
     *   A configuration array containing information about the plugin instance.
     * @param string $plugin_id
     *   The plugin ID for the plugin instance.
     * @param array $plugin_definition
     *   The plugin implementation definition.
     * @param \Drupal\smssystem\Services\SmsSend $sms_send
     *   The node storage.
     */
    final public function __construct(array $configuration, $plugin_id, array $plugin_definition, SmsSend $sms_send) {
      parent::__construct($configuration, $plugin_id, $plugin_definition);
      
      $this->smsSend = $sms_send;
    }
    
    /**
     * {@inheritdoc}
     */
    public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
      return new static(
        $configuration,
        $plugin_id,
        $plugin_definition,
        $container->get('smssystem.send_sms')
      );
    }
  
    /**
     * {@inheritdoc}
     */
    public function processItem($data) {
      // Send the SMS to the recipient.
      return $this->smsSend->sendSms($data->to, $data->text);
    }
  
  }
