# SOAP Manager

A Drupal module that provides a framework for creating and managing SOAP services in Drupal 9/10.

## Features

- Plugin-based SOAP resource system
- Authentication handling for SOAP requests
- Customizable SOAP response templates
- Configurable endpoints and services
- Permission-based access control
- Logging capabilities for SOAP requests and responses

## Installation

1. Download and place this module in your Drupal installation under `web/modules/custom/`
2. Enable the module via Drush: `drush en soap_manager`
3. Configure permissions at `/admin/people/permissions`

## Usage

### Creating a SOAP Resource

Create a new SOAP resource by implementing the SoapResource plugin:

```php
/**
 * @SoapResource(
 *   id = "my_soap_resource",
 *   label = @Translation("My SOAP Resource"),
 *   description = @Translation("Description of my SOAP resource.")
 * )
 */
class MySoapResource extends SoapResourceBase implements ContainerFactoryPluginInterface {

  /**
   * {@inheritdoc}
   */
  public function processRequest(array $request) {
    // Process the SOAP request and return response.
    return [
      'Header' => [
        'guid' => $this->generateGuid(),
        'createDateTime' => date('c'),
      ],
      'Body' => [
        // Response data
      ],
    ];
  }
}
```

### Configuring SOAP Endpoints

1. Navigate to `/admin/config/services/soap-manager`
2. Add or edit SOAP endpoints
3. Configure authentication methods and access permissions

### Handling Authentication

The module provides default authentication handlers, but you can create custom ones by implementing the appropriate interfaces.

## Available Services

The module provides the following services:

- `soap_manager.factory`: Creates SOAP resource instances
- `soap_manager.processor`: Processes incoming SOAP requests
- `soap_manager.logger`: Logs SOAP request/response data
- `soap_manager.wsdl_generator`: Generates WSDL files for services

## Hook System

Extend the module functionality with these hooks:

- `hook_soap_manager_resource_alter`: Modify SOAP resources
- `hook_soap_manager_response_alter`: Alter SOAP responses before they're sent
- `hook_soap_manager_request_alter`: Alter SOAP requests after they're received

## Troubleshooting

### Common Issues

- **SOAP Fault Responses**: Check your resource implementation for proper exception handling
- **Authentication Errors**: Verify credentials and authentication configuration
- **WSDL Generation Issues**: Make sure your resource plugin annotations are correct

## Resources

- [SOAP for PHP](https://www.php.net/manual/en/book.soap.php)
- [Drupal Plugin API](https://www.drupal.org/docs/drupal-apis/plugin-api)
- [SOAP Manager project page](https://www.drupal.org/project/soap_manager)
