<?php

namespace Drupal\soap_manager\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a SOAP resource annotation object.
 *
 * Plugin Namespace: Plugin\SoapResource
 *
 * @see \Drupal\soap_manager\Plugin\SoapResourceManager
 * @see plugin_api
 *
 * @Annotation
 */
class SoapResource extends Plugin {

  /**
   * The resource ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the SOAP resource.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A brief description of the SOAP resource.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description = '';

  /**
   * The weight of this SOAP resource (used for sorting).
   *
   * Lower numbers appear before higher numbers.
   *
   * @var int
   */
  public $weight = 0;

  /**
   * The default configuration for this resource.
   *
   * @var array
   */
  public $default_configuration = [];

}
