<?php

declare(strict_types=1);

namespace Drupal\soap_manager\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for SOAP request log entities.
 */
interface SoapManagerLogRequestInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  /**
   * Gets the SOAP endpoint ID.
   *
   * @return string|null
   *   The endpoint ID.
   */
  public function getEndpointId(): ?string;

  /**
   * Sets the SOAP endpoint ID.
   *
   * @param string $endpoint_id
   *   The endpoint ID.
   *
   * @return $this
   */
  public function setEndpointId(string $endpoint_id): self;

  /**
   * Gets the client IP address.
   *
   * @return string|null
   *   The client IP address.
   */
  public function getClientIp(): ?string;

  /**
   * Sets the client IP address.
   *
   * @param string $ip
   *   The client IP address.
   *
   * @return $this
   */
  public function setClientIp(string $ip): self;

  /**
   * Gets the creation timestamp.
   *
   * @return int
   *   The creation timestamp.
   */
  public function getCreatedTime(): int;

  /**
   * Sets the creation timestamp.
   *
   * @param int $timestamp
   *   The creation timestamp.
   *
   * @return $this
   */
  public function setCreatedTime(int $timestamp): self;

  public function getResponseLogId(): ?int;

}


