<?php

declare(strict_types=1);

namespace Drupal\soap_manager\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;

/**
 * Provides an interface for SOAP response log entities.
 */
interface SoapManagerLogResponseInterface extends ContentEntityInterface, EntityChangedInterface {

  /**
   * Gets the associated request log ID.
   *
   * @return int|null
   *   The request log ID.
   */
  public function getRequestLogId(): ?int;

  /**
   * Sets the associated request log ID.
   *
   * @param int $request_log_id
   *   The request log ID.
   *
   * @return $this
   */
  public function setRequestLogId(int $request_log_id): self;

  /**
   * Gets the HTTP status code.
   *
   * @return int|null
   *   The HTTP status code.
   */
  public function getStatusCode(): ?int;

  /**
   * Sets the HTTP status code.
   *
   * @param int $status_code
   *   The HTTP status code.
   *
   * @return $this
   */
  public function setStatusCode(int $status_code): self;

  /**
   * Gets whether the response was successful.
   *
   * @return bool
   *   TRUE if successful, FALSE otherwise.
   */
  public function isSuccess(): bool;

  /**
   * Sets whether the response was successful.
   *
   * @param bool $success
   *   TRUE if successful, FALSE otherwise.
   *
   * @return $this
   */
  public function setSuccess(bool $success): self;

  /**
   * Gets the creation timestamp.
   *
   * @return int
   *   The creation timestamp.
   */
  public function getCreatedTime(): int;

  /**
   * Sets the creation timestamp.
   *
   * @param int $timestamp
   *   The creation timestamp.
   *
   * @return $this
   */
  public function setCreatedTime(int $timestamp): self;

}


