<?php

declare(strict_types=1);

namespace Drupal\soap_manager\Exception;

/**
 * Exception thrown by SOAP resources with additional error information.
 */
class SoapResourceException extends \Exception {

  /**
   * The error name to be used in SOAP responses.
   *
   * @var string
   */
  protected string $errorName;

  /**
   * Constructs a new SoapResourceException object.
   *
   * @param string $message
   *   The Exception message.
   * @param string $errorName
   *   The error name to be used in SOAP responses.
   * @param int $code
   *   The Exception code.
   * @param \Throwable|null $previous
   *   The previous throwable used for exception chaining.
   */
  public function __construct(string $message, string $errorName, int $code = 0, ?\Throwable $previous = null) {
    parent::__construct($message, $code, $previous);
    $this->errorName = $errorName;
  }

  /**
   * Gets the error name.
   *
   * @return string
   *   The error name.
   */
  public function getErrorName(): string {
    return $this->errorName;
  }

}
