<?php

namespace Drupal\soap_manager\Form;

use Drupal\Core\Entity\EntityConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Form handler for deleting SOAP endpoint entities.
 */
class SoapManagerDeleteForm extends EntityConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete SOAP endpoint %name?', [
      '%name' => $this->entity->label(),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('entity.soap_manager.collection');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    /** @var \Drupal\soap_manager\Entity\SoapManagerInterface $entity */
    $entity = $this->entity;
    $entity_name = $entity->label();

    $entity->delete();

    $this->messenger()->addStatus($this->t('SOAP endpoint %name has been deleted.', [
      '%name' => $entity_name,
    ]));

    $this->logger('soap_manager')->notice('Deleted SOAP endpoint %name', [
      '%name' => $entity_name,
    ]);

    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
