<?php

namespace Drupal\soap_manager\Plugin\SoapResource;

use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Base class for SOAP resource plugins.
 */
abstract class SoapResourceBase extends PluginBase implements SoapResourceInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function getResourceId() {
    return $this->getPluginId();
  }

  /**
   * {@inheritdoc}
   */
  public function getResourceLabel() {
    return $this->pluginDefinition['label'];
  }

  /**
   * Generates a GUID for use in SOAP responses.
   *
   * @return string
   *   A generated GUID.
   */
  protected function generateGuid(): string {
    return sprintf(
      '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
      mt_rand(0, 0xffff),
      mt_rand(0, 0xffff),
      mt_rand(0, 0xffff),
      mt_rand(0, 0x0fff) | 0x4000,
      mt_rand(0, 0x3fff) | 0x8000,
      mt_rand(0, 0xffff),
      mt_rand(0, 0xffff),
      mt_rand(0, 0xffff)
    );
  }

}
