<?php

namespace Drupal\soap_manager\Plugin\SoapResource;

/**
 * Interface for SOAP resource plugins.
 */
interface SoapResourceInterface {

  /**
   * Returns the resource ID.
   *
   * @return string
   *   The resource ID.
   */
  public function getResourceId();

  /**
   * Returns the resource label.
   *
   * @return string
   *   The resource label.
   */
  public function getResourceLabel();

  /**
   * Process the request.
   *
   * @param array $request
   *   The request.
   *
   * @return array
   */
  public function processRequest(array $request);

}
