<?php

namespace Drupal\soap_manager\Service;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Provides access to SOAP Endpoint module settings.
 */
class ModuleSettings {

  /**
   * The config factory service.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * The settings config object.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected $config;

  /**
   * Constructs a ModuleSettings object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory service.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
    $this->config = $config_factory->get('soap_manager.settings');
  }

  /**
   * Checks if request logging is enabled.
   *
   * @return bool
   *   TRUE if request logging is enabled, FALSE otherwise.
   */
  public function isRequestLoggingEnabled() {
    return (bool) $this->config->get('logging.log_requests');
  }

  /**
   * Checks if response logging is enabled.
   *
   * @return bool
   *   TRUE if response logging is enabled, FALSE otherwise.
   */
  public function isResponseLoggingEnabled() {
    return (bool) $this->config->get('logging.log_responses');
  }

  /**
   * Checks if error logging is enabled.
   *
   * @return bool
   *   TRUE if error logging is enabled, FALSE otherwise.
   */
  public function isErrorLoggingEnabled() {
    return (bool) $this->config->get('logging.log_errors');
  }

}
