<?php

declare(strict_types=1);

namespace Drupal\soap_manager;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access controller for SOAP log entities.
 */
class SoapManagerLogAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account): AccessResult {
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view soap logs');

      case 'delete':
        return AccessResult::allowedIfHasPermissions($account, [
          'administer soap endpoints',
          'view soap logs',
        ], 'AND');

      default:
        return AccessResult::neutral();
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL): AccessResult {
    // Only the system can create log entities.
    return AccessResult::forbidden();
  }

}


