<?php

declare(strict_types=1);

namespace Drupal\sobki_admin\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\sobki_admin\Plugin\TopBarItem\PageActions;

/**
 * Hook implementations to alter Navigation.
 */
class Navigation {

  /**
   * Implements hook_top_bar_item_alter().
   *
   * Remove default page_actions as we provides our own.
   */
  #[Hook('top_bar_item_alter')]
  public function topBarItemAlter(array &$topBarItems): void {
    if (isset($topBarItems['page_actions'])) {
      $topBarItems['page_actions']['class'] = PageActions::class;
      $topBarItems['page_actions']['provider'] = 'sobki_admin';
    }
  }

}
