<?php

declare(strict_types=1);

namespace Drupal\sobki_background_image\HookHandler;

use Drupal\block\BlockInterface;

/**
 * Handle block presave.
 */
class BlockPresave {

  /**
   * Set third party settings.
   *
   * @param \Drupal\block\BlockInterface $block
   *   The block being pre-saved.
   */
  public function setThirdPartySettings(BlockInterface $block): void {
    $backgroundImage = $block->get('sobki_background_image');
    if ($backgroundImage == NULL || !\is_array($backgroundImage)) {
      return;
    }
    foreach ($backgroundImage as $key => $setting) {
      if (!empty($setting)) {
        $block->setThirdPartySetting('sobki_background_image', $key, $setting);
      }
      else {
        $block->unsetThirdPartySetting('sobki_background_image', $key);
      }
    }
  }

}
