<?php

declare(strict_types=1);

namespace Drupal\sobki_theme_bootstrap\HookHandler;

use Drupal\Component\Utility\NestedArray;

/**
 * Alter libraries.
 */
class LibraryInfoAlter {

  public const string FRAMEWORK_CSS_LIBRARY = 'sobki_theme_bootstrap/framework';

  public const array DEPENDENCIES_MAPPING = [
    'components.ui_suite_bootstrap--accordion' => [
      'sobki_theme_bootstrap/component_accordion',
    ],
    'components.ui_suite_bootstrap--accordion_item' => [
      'sobki_theme_bootstrap/component_accordion',
    ],
    'components.ui_suite_bootstrap--alert' => [
      'sobki_theme_bootstrap/component_alert',
    ],
    'components.ui_suite_bootstrap--badge' => [
      'sobki_theme_bootstrap/component_badge',
    ],
    'components.ui_suite_bootstrap--breadcrumb' => [
      'sobki_theme_bootstrap/component_breadcrumb',
    ],
    'components.ui_suite_bootstrap--button_group' => [
      'sobki_theme_bootstrap/component_button_group',
    ],
    'components.ui_suite_bootstrap--button_toolbar' => [
      'sobki_theme_bootstrap/component_button_group',
    ],
    'components.ui_suite_bootstrap--card' => [
      'sobki_theme_bootstrap/component_card',
    ],
    'components.ui_suite_bootstrap--card_body' => [
      'sobki_theme_bootstrap/component_card',
    ],
    'components.ui_suite_bootstrap--card_group' => [
      'sobki_theme_bootstrap/component_card',
    ],
    'components.ui_suite_bootstrap--card_overlay' => [
      'sobki_theme_bootstrap/component_card',
    ],
    'components.ui_suite_bootstrap--carousel' => [
      'sobki_theme_bootstrap/component_carousel',
    ],
    'components.ui_suite_bootstrap--carousel_item' => [
      'sobki_theme_bootstrap/component_carousel',
    ],
    'components.ui_suite_bootstrap--close_button' => [
      'sobki_theme_bootstrap/component_close_button',
    ],
    'components.ui_suite_bootstrap--dropdown' => [
      'sobki_theme_bootstrap/component_dropdown',
      'sobki_theme_bootstrap/component_button_group',
    ],
    'components.ui_suite_bootstrap--list_group' => [
      'sobki_theme_bootstrap/component_list_group',
    ],
    'components.ui_suite_bootstrap--list_group_item' => [
      'sobki_theme_bootstrap/component_list_group',
    ],
    'components.ui_suite_bootstrap--modal' => [
      'sobki_theme_bootstrap/component_modal',
    ],
    'components.ui_suite_bootstrap--nav' => [
      'sobki_theme_bootstrap/component_nav',
    ],
    'components.ui_suite_bootstrap--navbar' => [
      'sobki_theme_bootstrap/component_navbar',
    ],
    'components.ui_suite_bootstrap--navbar_nav' => [
      'sobki_theme_bootstrap/component_nav',
      'sobki_theme_bootstrap/component_navbar',
    ],
    'components.ui_suite_bootstrap--offcanvas' => [
      'sobki_theme_bootstrap/component_offcanvas',
    ],
    'components.ui_suite_bootstrap--pagination' => [
      'sobki_theme_bootstrap/component_pagination',
    ],
    'components.ui_suite_bootstrap--progress' => [
      'sobki_theme_bootstrap/component_progress',
    ],
    'components.ui_suite_bootstrap--progress_stacked' => [
      'sobki_theme_bootstrap/component_progress',
    ],
    'components.ui_suite_bootstrap--spinner' => [
      'sobki_theme_bootstrap/component_spinner',
    ],
    'components.ui_suite_bootstrap--table' => [
      'sobki_theme_bootstrap/component_table',
    ],
    'components.ui_suite_bootstrap--table_cell' => [
      'sobki_theme_bootstrap/component_table',
    ],
    'components.ui_suite_bootstrap--table_row' => [
      'sobki_theme_bootstrap/component_table',
    ],
    'components.ui_suite_bootstrap--toast' => [
      'sobki_theme_bootstrap/component_toast',
    ],
    'components.ui_suite_bootstrap--toast_container' => [
      'sobki_theme_bootstrap/component_toast',
    ],
  ];

  /**
   * Alter libraries.
   *
   * @param array $libraries
   *   An associative array of libraries, passed by reference.
   * @param string $extension
   *   Can either be 'core' or the machine name of the extension that registered
   *   the libraries.
   */
  public function alter(array &$libraries, string $extension): void {
    if ($extension != 'core') {
      return;
    }

    $css_library = \theme_get_setting('library.css_loading') ?? '';
    // Attach dynamically to components the split CSS.
    if ($css_library != static::FRAMEWORK_CSS_LIBRARY) {
      return;
    }

    foreach (static::DEPENDENCIES_MAPPING as $library => $dependencies) {
      if (!isset($libraries[$library]) || !\is_array($libraries[$library])) {
        continue;
      }

      $libraries[$library] = NestedArray::mergeDeepArray([$libraries[$library], ['dependencies' => $dependencies]]);
    }
  }

}
