<?php

declare(strict_types=1);

namespace Drupal\sobki_background_image\Service;

/**
 * Defines an interface for background image style generators.
 */
interface BackgroundImageStyleInterface {

  /**
   * Get a background image inline style.
   *
   * @param array $settings
   *   The background image settings.
   *
   * @return array
   *   The background image inline style as an array.
   */
  public function getBackgroundImageStyle(array $settings): array;

}
