<?php

declare(strict_types=1);

namespace Drupal\sobki_theme_bootstrap_starterkit\HookHandler;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Alter theme settings form.
 */
class FormSystemThemeSettingsAlter {

  use StringTranslationTrait;

  /**
   * Add this theme CSS into the options.
   *
   * @param array $form
   *   Nested array of form elements that comprise the form.
   * @param \Drupal\Core\Form\FormStateInterface $formState
   *   The current state of the form.
   */
  public function alter(array &$form, FormStateInterface $formState): void {
    if (isset($form['ui_suite_bootstrap']['library']['css_loading']['#options'])) {
      $form['ui_suite_bootstrap']['library']['css_loading']['#options']['Sobki']['sobki_theme_bootstrap_starterkit/framework'] = $this->t('Sobki starterkit');
    }
  }

}
