<?php

/**
 * @file
 * Contains hook implementations for sobki_profile_dsfr profile.
 */

declare(strict_types=1);

/**
 * Implements hook_install_tasks().
 */
function sobki_profile_dsfr_install_tasks(array &$install_state): array {
  return [
    'sobki_profile_dsfr_enable_default_content' => [],
    'sobki_profile_dsfr_set_default_language' => [],
  ];
}

/**
 * Enable default content module.
 *
 * Done in an installation task to avoid to introduce a hook_install in the
 * installation profile. And therefore to avoid the core bug:
 * https://www.drupal.org/project/drupal/issues/2982052
 *
 * Not possible to add the module in .info.yml file as the configuration needs
 * to be imported before.
 *
 * @param array $install_state
 *   An array of information about the current installation state.
 */
function sobki_profile_dsfr_enable_default_content(array &$install_state): void {
  /** @var \Drupal\Core\Extension\ModuleInstallerInterface $module_installer */
  $module_installer = \Drupal::service('module_installer');
  $module_installer->install([
    'sobki_default_content',
  ]);
}

/**
 * Set the default language to French.
 *
 * @param array $install_state
 *   An array of information about the current installation state.
 */
function sobki_profile_dsfr_set_default_language(array &$install_state): void {
  // Set French as the default language.
  \Drupal::configFactory()
    ->getEditable('system.site')
    ->set('default_langcode', 'fr')
    ->save();
}
