<?php

namespace Drupal\social_event;

use Drupal\Core\Link;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Url;

/**
 * Defines a class to build a listing of Event enrollment entities.
 *
 * @ingroup social_event
 */
class EventEnrollmentListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header = [];
    $header['id'] = $this->t('Event enrollment ID');
    $header['name'] = $this->t('Name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row = [];
    /** @var \Drupal\social_event\Entity\EventEnrollment $entity */
    $row['id'] = $entity->id();
    $label = $entity->label();
    if (!empty($label)) {
      $row['name'] = Link::fromTextAndUrl($label, new Url(
        'entity.event_enrollment.edit_form', [
          'event_enrollment' => $entity->id(),
        ]
      ));
    }
    return $row + parent::buildRow($entity);
  }

}
