<?php

namespace Drupal\activity_send_email\Plugin\ActivitySend;

use Drupal\activity_creator\ActivityInterface;
use Drupal\activity_send\Plugin\ActivitySendBase;

/**
 * Provides a 'EmailActivitySend' activity action.
 *
 * @ActivitySend(
 *  id = "email_activity_send",
 *  label = @Translation("Action that is triggered when a entity is created"),
 * )
 */
class EmailActivitySend extends ActivitySendBase {

  /**
   * {@inheritdoc}
   */
  public function process(ActivityInterface $entity) : void {
    $data['entity_id'] = $entity->id();
    $queue = \Drupal::queue('activity_send_email_worker');
    $queue->createItem($data);
  }

}
