@api
Feature: Add profile tags to the user profiles
  Benefit: In order to add profile tags
  Role: CM
  Goal/desire: I want to be able to add profile tags

  Scenario: Disable access to add profile tags
    Given users:
      | name   | status | uid | roles    |
      | Member | 1      | 999 | verified |

    When I am logged in as an "sitemanager"
    And I go to "/admin/config/people/social-profile"
    And I uncheck the box "Allow profile tagging for content managers"
    And I press "Save configuration"
    And I go to "/user/999/profile"

    Then I should not see the text "Profile tag"

  Scenario: Enable profile tags without split
    Given "profile_tag" terms:
      | name                | parent |
      | Behat Profile tag 1 |        |
      | Behat Profile tag 2 |        |
    And users:
      | name   | status | uid | roles    |
      | Member | 1      | 999 | verified |

    When I am logged in as an "sitemanager"
    And I go to "/admin/config/people/social-profile"
    And I check the box "Allow profile tagging for content managers"
    And I uncheck the box "Allow category split"
    And I press "Save configuration"

    And I am logged in as an "contentmanager"
    And I go to "/user/999/profile"
    And I select "Behat Profile tag 1" from "Profile tag"
    And I additionally select "Behat Profile tag 2" from "Profile tag"
    And I press "Save"
    And I go to "/user/999/information"

    Then I should see "Profile tags"
    And I should see "Behat Profile tag 1"
    And I should see "Behat Profile tag 2"

  Scenario: Enable profile tag split
    Given "profile_tag" terms:
      | name                  | parent              |
      | Behat Profile tag 1   |                     |
      | Behat Profile tag 1.1 | Behat Profile tag 1 |
      | Behat Profile tag 1.2 | Behat Profile tag 1 |
      | Behat Profile tag 2   |                     |
      | Behat Profile tag 2.1 | Behat Profile tag 2 |
      | Behat Profile tag 2.2 | Behat Profile tag 2 |
    And users:
      | name   | status | uid | roles    |
      | Member | 1      | 999 | verified |

    And I am logged in as an "sitemanager"
    And I go to "/admin/config/people/social-profile"
    And I check the box "Allow profile tagging for content managers"
    And I check the box "Allow category split"
    And I press "Save configuration"
    And I am logged in as an "contentmanager"
    And I go to "/user/999/profile"
    And I select "Behat Profile tag 1.1" from "Behat Profile tag 1"
    And I additionally select "Behat Profile tag 1.2" from "Behat Profile tag 1"
    And I select "Behat Profile tag 2.1" from "Behat Profile tag 2"
    And I additionally select "Behat Profile tag 2.2" from "Behat Profile tag 2"
    And I press "Save"
    And I go to "/user/999/information"

    And I should see "Behat Profile tag 1"
    And I should see "Behat Profile tag 1.1"
    And I should see "Behat Profile tag 1.2"
    And I should see "Behat Profile tag 2"
    And I should see "Behat Profile tag 2.1"
    And I should see "Behat Profile tag 2.2"

  Scenario: Allow to select parents
    Given "profile_tag" terms:
      | name                  | parent              |
      | Behat Profile tag 1   |                     |
      | Behat Profile tag 1.1 | Behat Profile tag 1 |
      | Behat Profile tag 2   |                     |
      | Behat Profile tag 2.1 | Behat Profile tag 2 |
    And users:
      | name   | status | uid | roles    |
      | Member | 1      | 999 | verified |

    And I am logged in as an "sitemanager"
    And I go to "/admin/config/people/social-profile"
    And I check the box "Allow profile tagging for content managers"
    And I check the box "Allow category split"
    And I check the box "Allow parents to be used as tag"
    And I press "Save configuration"

    And I am logged in as an "contentmanager"
    And I go to "/user/999/profile"
    And I select "Behat Profile tag 1" from "Behat Profile tag 1"
    And I additionally select "Behat Profile tag 1.1" from "Behat Profile tag 1"
    And I select "Behat Profile tag 2" from "Behat Profile tag 2"
    And I additionally select "Behat Profile tag 2.1" from "Behat Profile tag 2"
    And I press "Save"
    And I go to "/user/999/information"

    And I should see "Behat Profile tag 1"
    And I should see "Behat Profile tag 1.1"
    And I should see "Behat Profile tag 2"
    And I should see "Behat Profile tag 2.1"
