<?php

namespace Drupal\social_auth_decoupled;

use League\OAuth2\Client\Provider\ResourceOwnerInterface;

/**
 * SocialAuthHttpInterface.
 *
 * Defines a common interface for providers modules.
 */
interface SocialAuthHttpInterface {

  /**
   * Authenticate user by profile.
   *
   * @param \League\OAuth2\Client\Provider\ResourceOwnerInterface $profile
   *   The Profile.
   * @param string $data
   *   The additional user_data to be stored in database.
   *
   * @return array
   *   The array of associated login value.
   */
  public function authenticateUserByProfile(ResourceOwnerInterface $profile, $data);

}
