# Social Auth Google One Tap

## Overview

This module enhances the **Social Auth Google** module by integrating Google One Tap login. It provides a seamless, low-friction sign-in experience for users, allowing them to log in or sign up with a single click without leaving the current page.

This module is designed to work alongside the standard Google OAuth2 login flow provided by `social_auth_google`. Users logging in via One Tap will have the same Drupal session and user account as if they had used the traditional "Sign in with Google" button.

## Table of contents

- [Features](#features)
- [How It Works](#how-it-works)
- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Support](#support)
- [Maintainers](#maintainers)
- [License](#license)

## Features

- **Seamless Login**: Displays the Google One Tap prompt for anonymous users.
- **Unified User Experience**: Leverages the core `social_auth` framework to ensure users are correctly identified, created, and logged in, regardless of the authentication method (One Tap vs. standard OAuth).
- **Shared Configuration**: Reuses the Google Client ID from the `social_auth_google` module settings, requiring no duplicate configuration.
- **Logout Auto-Login Prevention**: Prevents immediate automatic One Tap login after a user explicitly logs out, improving user experience by respecting their logout intention. Verifies the Google ID Token on the server-side to ensure authenticity.

## How It Works

1.  **Frontend (Google GSI Library)**: For anonymous users, the module loads Google's Identity Services (GSI) JavaScript library. This library displays the One Tap prompt.
2.  **ID Token Callback**: When a user successfully signs in with One Tap, Google returns a JSON Web Token (JWT) called an ID Token to the browser.
3.  **Backend Verification**: The module's JavaScript sends this ID Token to a custom Drupal backend endpoint (`/user/login/google/one-tap-callback`).
4.  **User Authentication**: The backend controller:
    a. Receives the ID Token.
    b. Uses the `google/apiclient` library to securely verify the token against the configured Google Client ID.
    c. On successful verification, it extracts the user's profile information (Google ID, email, name, etc.).
    d. It then passes this information to the core `social_auth` User Authenticator service, using the `social_auth_google` plugin ID.
5.  **Session Management**: The `social_auth` service handles the rest: finding an existing user with the same Google ID, creating a new user if one doesn't exist, and establishing a Drupal session.

## Requirements

- **Drupal 9.5+ or 10+**
- **[Social Auth](https://www.drupal.org/project/social_auth)** module
- **[Social Auth Google](https://www.drupal.org/project/social_auth_google)** module
- **[google/apiclient](https://packagist.org/packages/google/apiclient)** PHP library (will be installed via Composer).

## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

This module requires the `google/apiclient` PHP library. You can install it by running the following command from your project root:

```bash
composer require google/apiclient:"^2.15"
```

Then, enable the "Social Auth Google One Tap" module in the Drupal admin UI or by running:

```bash
drush en social_auth_google_one_tap
```

## Configuration

This module primarily relies on the configuration of the **Social Auth Google** module. Ensure that `social_auth_google` is installed and configured correctly, especially with a valid Google Client ID saved in its settings at `/admin/config/social-api/social-auth/google`.

Additionally, you must configure your Google Cloud Project:

1.  In your [Google Cloud Console](https://console.cloud.google.com/), navigate to **APIs & Services > Credentials**.
2.  Edit your OAuth 2.0 Client ID.
3.  Under **Authorized JavaScript origins**, make sure your site's domain (e.g., `https://example.com`, `http://localhost:8000`) is listed. This is crucial for the Google One Tap UI to be displayed and function correctly.

## Support

For bug reports, feature requests, or general support, please use the [issue queue on Drupal.org](https://www.drupal.org/project/issues/social_auth_google_one_tap).

## License

This project is licensed under the GNU General Public License, version 2 or later. See the [LICENSE.txt](LICENSE.txt) file in the module directory for full details.
