import globals from 'globals';
import eslint from '@eslint/js';
import pluginPrettierRecommended from 'eslint-plugin-prettier/recommended';

/** @type {import('eslint').Linter.Config[]} */
export default [
  { files: ['**/*.{js,mjs,cjs}'] },
  {
    ignores: ['src/', '**/node_modules/'],
  },
  {
    languageOptions: {
      globals: {
        ...globals.browser,
        Drupal: true,
        drupalSettings: true,
        once: true,
      },
    },
  },
  eslint.configs.recommended,
  pluginPrettierRecommended,
];
