((Drupal, once) => {
  'use strict';

  Drupal.behaviors.socialAuthModalClose = {
    // eslint-disable-next-line
    attach: (context, settings) => {
      const closePopup = () => {
        if (window.opener) {
          window.opener.location.reload();
        }
        window.close();

        // To override/perform additional actions on modal window closing,
        // it is possible to call the function defined in the opener window
        // instead of/in addition to actions in this function.
        //
        // window.opener.SocialAuthModalClose();
      };

      once('modalAutoClose', 'html').forEach(() => {
        closePopup();
      });

      once('modalCloseButton', '.social-auth-modal__close').forEach(element => {
        element.addEventListener('click', closePopup);
      });
    },
  };
})(Drupal, once);
