((Drupal, once) => {
  'use strict';

  Drupal.behaviors.socialAuthModalOpen = {
    attach: (context, settings) => {
      const modalWidth = settings.socialAuthModal?.width ?? 560;
      const modalHeight = settings.socialAuthModal?.width ?? 720;

      // Opens a modal window at the center of the page.
      // Based on http://www.xtf.dk/2011/08/center-new-popup-window-even-on.html.
      const popupCenter = (url, title, modalWidth, modalHeight) => {
        // Fixes dual-screen position.
        const dualScreenLeft = window.screenLeft !== undefined ? window.screenLeft : window.screenX;
        const dualScreenTop = window.screenTop !== undefined ? window.screenTop : window.screenY;

        const screenWidth = window.innerWidth
          ? window.innerWidth
          : document.documentElement.clientWidth
            ? document.documentElement.clientWidth
            : screen.width;
        const screenHeight = window.innerHeight
          ? window.innerHeight
          : document.documentElement.clientHeight
            ? document.documentElement.clientHeight
            : screen.height;

        const left = screenWidth / 2 - modalWidth / 2 + dualScreenLeft;
        const top = screenHeight / 2 - modalHeight / 2 + dualScreenTop;
        const newWindow = window.open(
          url,
          title,
          'toolbar=no, location=no, status=no, menubar=no, scrollbars=yes, resizable=yes, width=' +
            modalWidth +
            ', height=' +
            modalHeight +
            ', top=' +
            top +
            ', left=' +
            left,
        );

        // Puts focus on the newWindow.
        if (window.focus) {
          newWindow.focus();
        }

        return newWindow;
      };

      const handleOpenClick = (e, element) => {
        e.stopPropagation();
        e.preventDefault();

        const href = element.getAttribute('href');

        popupCenter(href, 'User authentication', modalWidth, modalHeight);

        // In case of overriding/performing additional actions on the modal window closing,
        // assign a modal window object to variable instead of just calling the function.
        //
        // SocialAuthModal = popupCenter(href, 'User authentication', modalWidth, modalHeight);
      };

      once('modalOpen', '.social-auth-modal__link', context).forEach(element => {
        element.addEventListener('click', e => handleOpenClick(e, element));
      });
    },
  };
})(Drupal, once);

// An example of the function which should be called from a modal window
// for overriding/performing additional actions.
//
// function SocialAuthModalClose() {
//   if (SocialAuthModal) {
//     SocialAuthModal.close();
//   }
//   window.location.reload();
// };
