<?php

namespace Drupal\social_post_instagram\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Settings form for Social Post Instagram.
 */
class InstagramPostSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['social_post_instagram.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'social_post_instagram.form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('social_post_instagram.settings');
    $current_request = $this->getRequest();

    $form['ig_settings'] = [
      '#type' => 'details',
      '#title' => $this->t('Instagram App settings'),
      '#open' => TRUE,
      '#description' => $this->t('You need to first create a Facebook App at <a href="@facebook-dev">@facebook-dev</a>', ['@facebook-dev' => 'https://developers.facebook.com/apps']),
    ];

    $form['ig_settings']['app_id'] = [
      '#type' => 'textfield',
      '#required' => TRUE,
      '#title' => $this->t('Application ID'),
      '#default_value' => $config->get('app_id'),
      '#description' => $this->t('Copy the App ID of your Facebook App here. This value can be found from your App Dashboard.'),
    ];

    $form['ig_settings']['app_secret'] = [
      '#type' => 'key_select',
      '#required' => TRUE,
      '#title' => $this->t('App Secret'),
      '#default_value' => $config->get('app_secret'),
      '#description' => $this->t('<br />Use the App Secret of your Facebook App here. This value can be found from your App Dashboard.'),
    ];

    $form['ig_settings']['graph_version'] = [
      '#type' => 'number',
      '#min' => 0,
      '#step' => 'any',
      '#required' => TRUE,
      '#title' => $this->t('Graph API version'),
      '#default_value' => $config->get('graph_version'),
      '#description' => $this->t('Use the up and down arrows to select the API Version matching that of your Facebook App. This value can be found from your App Dashboard. More information on API versions can be found at <a href="@facebook-changelog">Facebook Platform Changelog</a>', ['@facebook-changelog' => 'https://developers.facebook.com/docs/apps/changelog']),
    ];

    $form['ig_settings']['config_id'] = [
      '#type' => 'textfield',
      '#required' => FALSE,
      '#title' => $this->t('Facebook Business Login Config ID'),
      '#default_value' => $config->get('config_id'),
      '#description' => $this->t('If you are using Facebook Login for Business, you must create a configuration, and enter that Configuration ID here. If you are using Facebook Login (i.e. not business), leave this value blank.'),
    ];

    $form['ig_settings']['oauth_redirect_url'] = [
      '#type' => 'textfield',
      '#disabled' => TRUE,
      '#title' => $this->t('Valid OAuth redirect URIs'),
      '#description' => $this->t('Copy this value to <em>Valid OAuth redirect URIs</em> field of your Facebook App settings.'),
      '#default_value' => $GLOBALS['base_url'] . '/user/social-post/instagram/auth/callback',
    ];

    $form['ig_settings']['app_domains'] = [
      '#type' => 'textfield',
      '#disabled' => TRUE,
      '#title' => $this->t('App Domains'),
      '#description' => $this->t('Copy this value to <em>App Domains</em> field of your Facebook App settings.'),
      '#default_value' => $current_request->getHost(),
    ];

    $form['ig_settings']['site_url'] = [
      '#type' => 'textfield',
      '#disabled' => TRUE,
      '#title' => $this->t('Site URL'),
      '#description' => $this->t('Copy this value to <em>Site URL</em> field of your Facebook App settings.'),
      '#default_value' => $GLOBALS['base_url'],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();
    $this->config('social_post_instagram.settings')
      ->set('app_id', $values['app_id'])
      ->set('app_secret', $values['app_secret'])
      ->set('graph_version', $values['graph_version'])
      ->set('oauth_redirect_url', $values['oauth_redirect_url'])
      ->set('config_id', $values['config_id'])
      ->save();

    parent::submitForm($form, $form_state);
  }

}
