<?php

namespace Drupal\social_post_instagram\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Sitewide Instagram account form.
 */
class InstagramPostSitewideForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'social_post_instagram.sitwide_account_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    /** @var \Drupal\social_post\Entity\SocialPost[] $accounts */
    $accounts = _social_post_instagram_get_accounts_by_uid(0);

    $form['accounts'] = [
      '#type' => 'table',
      '#header' => [t('Screen name'), t('Operations')],
      '#empty' => t('You have not added any account yet.'),
    ];

    /** @var \Drupal\social_post\Entity\SocialPost $account */
    foreach ($accounts as $id => $account) {
      $form['accounts'][$id]['screen_name'] = [
        '#type' => 'link',
        '#title' => $account->getName(),
        '#url' => Url::fromUri('https://instagram.com/' . $account->getProviderUserId()),
      ];
      $form['accounts'][$id]['operations'] = [
        '#type' => 'operations',
        '#links' => [
          'delete' => [
            'title' => t('Delete'),
            'url' => Url::fromRoute('entity.social_post.delete_form', [
              'provider' => 'instagram',
              'social_post' => $account->getId(),
              'user' => 0,
            ]),
          ],
        ],
      ];
    }

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Add account'),
      '#access' => empty($accounts),
    ];

    $form['help'] = [
      '#type' => 'item',
      '#markup' => $this->t('When adding an account, please only authorize the app to post to a single page.'),
      '#access' => empty($accounts),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $url = Url::fromRoute('social_post_instagram.redirect_to_instagram_for_sitewide');
    $form_state->setRedirectUrl($url);
  }

}
