# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### Added
- Initial release of Social Summaries module
- AI-powered content generation for multiple platforms
- Vertical tab interface for content generation
- Drush commands for bulk processing
- JSON API endpoints for external integrations
- Comprehensive accessibility support (WCAG 2.1 AA)
- Rate limiting and cost tracking
- Customizable prompt templates
- Bundle-specific platform visibility settings
 - Per-bundle enable/disable toggle to hide the sidebar entirely
 - Select all / Deselect all controls on bundle settings
- Plugin system for AI providers (OpenAI, Anthropic)
- Conservative default settings to protect API quotas
- Automated CI/CD with GitLab

### Security
- Secure API key storage using Drupal Key module
- CSRF protection on all forms
- Proper access control and permissions
- Input validation and sanitization

## [1.0.0] - 2024-01-XX

### Added
- **Initial Release**
  - AI-powered summarization and multi-channel publishing
  - Support for OpenAI GPT models
  - Content generation for: Summary, LinkedIn, X (Twitter), Newsletter, Facebook, Threads
  - Real-time character counting with platform-specific limits
  - Content preview and edit workflow
  - Bulk processing with intelligent rate limiting
  - Drush integration with commands: `ss-gen`, `ss-bulk`, `ss-test`, `ss-stats`
  - JSON API endpoints for external integrations
  - Comprehensive configuration options
  - Customizable prompt templates with placeholder support
  - Bundle-specific platform visibility settings
  - Usage statistics and cost tracking
  - Full accessibility support (WCAG 2.1 AA compliant)
  - Comprehensive test suite with 90%+ code coverage

### Technical Details
- **Dependencies**: Drupal 10.x/11.x, PHP 8.1+, Key module
- **Architecture**: Service-oriented with proper dependency injection
- **Security**: Access control, CSRF protection, input validation
- **Performance**: Rate limiting, caching, optimized API calls
- **Testing**: Unit, Kernel, Functional, and Accessibility tests

### Upgrade Notes
- This is the initial release, so no upgrade path is needed
- Ensure you have the Key module installed before enabling Social Summaries
- Configure your OpenAI API key before using the module
- The module automatically creates AI content fields on all content types during installation
- Update hooks are provided to handle field changes in future versions

---

## Version Numbering

This project follows [Semantic Versioning](https://semver.org/):

- **MAJOR** version when you make incompatible API changes
- **MINOR** version when you add functionality in a backwards compatible manner  
- **PATCH** version when you make backwards compatible bug fixes

## Upgrade Instructions

### From 1.0.0 to future versions

1. **Backup your site** before upgrading
2. **Review the changelog** for any breaking changes
3. **Update the module** using your preferred method:
   - Composer: `composer update drupal/social_summaries`
   - Drush: `drush pm-update social_summaries`
   - Manual: Download and replace files
4. **Run database updates**: `drush updb`
5. **Clear caches**: `drush cr`
6. **Review configuration** for any new settings
7. **Test functionality** to ensure everything works as expected

### Breaking Changes

Breaking changes will be clearly marked in the changelog with upgrade instructions.

### Deprecations

Deprecated features will be marked with `@deprecated` in code and noted in the changelog. They will be removed in the next major version.
