# Social Summaries

Social Summaries is a Drupal 10/11 module that brings AI-powered content summarization and multi-channel publishing directly into Drupal. Built with modern PHP 8.1+ features, comprehensive security, and enterprise-grade reliability.

---

## 🚀 Features

- **Executive Summaries** - Professional summaries for reports and articles
- **Social Media Drafts** - LinkedIn, X (Twitter), Facebook, and Threads content
- **Newsletter Blurbs** - Engaging newsletter content with proper formatting
- **Customizable Prompt Templates** - Full control over AI generation prompts
- **Vertical Tab Interface** - Clean, organized UI for content generation
- **Real-time Character Counting** - Platform-specific character limits with accessibility support
- **Content Preview & Edit Workflow** - Review and edit before saving
- **Bulk Processing** - Process multiple nodes with rate limiting
- **Drush Integration** - Command-line tools for automation
- **JSON API** - RESTful endpoints for external integrations
- **Rate Limiting & Cost Tracking** - Monitor usage and prevent abuse
- **Comprehensive Security** - Access control, input validation, and error handling
- **Full Accessibility Support** - WCAG 2.1 AA compliant with screen reader support
- **Drupal 10/11 Compatible** - Built with modern Drupal standards

---

## 📦 Installation

### Requirements
- **Drupal 10.x/11.x**
- **PHP 8.1+**
- **Key module** (for secure API key storage)
- **OpenAI API key**

### Installation Steps

```bash
# Install the module
composer require drupal/social_summaries

# Enable required modules
drush en key social_summaries

# Clear caches
drush cr
```

**Note:** The Key module is required for secure API key storage and is automatically suggested during installation.

### From Source (Development)

For developers who want to contribute or test the latest features:

```bash
# Clone the repository
git clone https://git.drupalcode.org/project/social_summaries.git

# Or if using GitHub
git clone https://github.com/your-username/social_summaries.git

# Enable the module
drush en social_summaries

# Clear caches
drush cr
```

### Upgrade Notes

When upgrading between major versions, please review the [CHANGELOG.md](CHANGELOG.md) for breaking changes and upgrade instructions.

## ⚙️ Configuration

### Initial Setup

1. **Navigate to Configuration**: Go to **Configuration → Content authoring → Social Summaries**
2. **Create API Key**: Create an OpenAI API key in **Configuration → System → Key**
3. **Select API Key**: Choose your API key from the dropdown
4. **Choose Model**: Select your preferred OpenAI model (gpt-4.1-mini recommended)
5. **Configure Rate Limiting**: Set calls per minute/hour and delays
6. **Test Connection**: Use the "Test Connection" button to verify setup
7. **Assign Permissions**: Configure user permissions for content generation

### Advanced Configuration

- **Retry Settings**: Configure automatic retry attempts and timeouts
- **Custom Prompts**: Customize AI generation prompts for each content type
- **Rate Limiting**: Fine-tune API call limits and delays
- **Usage Tracking**: Monitor API usage and costs
- **Error Handling**: Configure logging and error reporting levels

### Platform Visibility, Per-Bundle Enable, and Field Attachment

- The global Visible Platforms setting controls which platform tabs appear by default across all content types (bundles).
- Each bundle has its own Social Summaries settings tab with:
  - An Enable toggle to turn Social Summaries on/off for that bundle. When disabled, the sidebar is hidden entirely.
  - An Override switch to customize which platforms are visible for that bundle.
  - Select all / Deselect all actions to quickly manage platform visibility.
- When you save global settings, the module ensures that the necessary AI fields are attached to all node bundles for the globally visible platforms so generated content persists on save.

### Saving Behavior (New and Existing Nodes)

- On new nodes, generation reads the current unsaved Title and Body values from the form; you can generate before the first save.
- On save, the module persists each platform’s textarea content. If the textarea wasn’t changed after generation, it falls back to the generated preview to ensure persistence.
- Saving an empty textarea clears previously saved generated content for that platform.

---

## 🖥️ Usage

### Content Generation Interface

The Social Summaries adds a **vertical tab interface** to node edit pages with the following features:

- **Individual Content Tabs**: Separate tabs for Summary, LinkedIn, X, Newsletter, Facebook, and Threads
- **Generate Buttons**: Click "Generate" to create content for each type
- **Real-time Character Counting**: Platform-specific character limits with visual indicators
- **Content Preview**: Review and edit generated content before saving
- **Loading States**: Beautiful animations and feedback during generation
- **Auto-save**: Content persists when saving the node
- **Regeneration**: Generate new content anytime with the Generate button

### Content Workflow

1. **Edit Node**: Open any article or content type for editing
2. **Generate Content**: Click "Generate" in desired content tabs
3. **Review & Edit**: Modify generated content as needed
4. **Save Node**: Click "Save" to store all content in Drupal fields
5. **Publish**: Use your preferred tools to publish to social platforms

### Command Line Interface (Drush)

```bash
# Generate content for a single node
drush ss-gen 123 --platforms=summary,linkedin,facebook,threads

# Bulk processing with intelligent rate limiting
drush ss-bulk --type=article --platforms=all --limit=20 --batch-size=3 --delay=2

# Preview what would be processed (dry run)
drush ss-bulk --type=article --platforms=summary --dry-run

# Test API connection
drush ss-test

# View usage statistics and costs
drush ss-stats
```

### JSON API Endpoints

```bash
# Generate and save content directly (requires CSRF token)
curl -X POST "/social-summaries/generate/123/summary" \
  -H "X-CSRF-Token: YOUR_CSRF_TOKEN" \
  -H "Content-Type: application/json"

# Generate for preview only (no saving)
curl -X POST "/social-summaries/generate/123/summary" \
  -H "X-CSRF-Token: YOUR_CSRF_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"preview_only": true}'

# Generate multiple content types
curl -X POST "/social-summaries/generate/123/all" \
  -H "X-CSRF-Token: YOUR_CSRF_TOKEN" \
  -H "Content-Type: application/json"

# Generate with custom parameters
curl -X POST "/social-summaries/generate/123/linkedin" \
  -H "X-CSRF-Token: YOUR_CSRF_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"title": "Custom Title", "body": "Custom Body"}'
```

Note: Requests accept JSON bodies. For backward compatibility, equivalent query parameters are also supported.

**Note:** All generation endpoints require POST requests with valid CSRF tokens for security. Obtain a CSRF token from `/session/token` endpoint.

---

## 🎨 Customizing Prompts

The Social Summaries module allows you to customize the prompts used for content generation:

### **Available Templates**
- **System Prompt**: Base AI role and instructions
- **Summary Template**: Constraints for executive summaries
- **LinkedIn Template**: Guidelines for LinkedIn posts
- **X Template**: Rules for X (Twitter) posts
- **Newsletter Template**: Instructions for newsletter content
- **Facebook Template**: Guidelines for Facebook posts
- **Threads Template**: Rules for Threads posts

### **Placeholder Tokens**
Use these placeholders in your custom templates:
- `{tone}` - Writing tone (configurable in settings: professional, casual, friendly, etc.)
- `{constraints}` - Platform-specific constraints
- `{title}` - Article title (in user prompt)
- `{body}` - Article body content (in user prompt)
- `{platform}` - Content platform (in user prompt)

### **Tone Customization**
The Social Summaries module allows you to set a default tone for all generated content:
- **Neutral, Professional** (default)
- **Casual, Friendly**
- **Authoritative, Expert**
- **Conversational, Engaging**
- **Concise, Direct**
- **Warm, Personal**
- **Technical, Detailed**
- **Creative, Inspiring**

The tone can be customized in the settings form and will be used in the `{tone}` placeholder in your prompt templates.

### **Example Custom System Prompt**
```
You are a {tone} marketing copywriter specializing in {industry}. 
Follow these platform constraints: {constraints}
Always include relevant hashtags and maintain brand consistency.
```

### **Accessing Prompt Templates**
1. Go to **Configuration → Content authoring → Social Summaries**
2. Expand the **"Prompt Templates"** section
3. Customize any template using the textarea fields
4. Use the **"Reset to Defaults"** button to restore original templates

---

## 🔄 Content Workflow

The Social Summaries module provides a complete content creation and management workflow:

### **1. Generate Content**
- Click **"Generate"** buttons in each vertical tab
- AI creates platform-specific content based on your article
- Content appears in textareas for review and editing

### **2. Preview & Edit**
- Review generated content in the textareas
- Edit content directly before saving
- Character counters help with platform limits
- Use **"Generate"** again to create new versions

### **3. Save Content**
- Click the main **"Save"** button to store all content in Drupal fields
- Content is saved locally and persists across page loads
- Creates new node revision with AI-generated content
- Logs usage for cost tracking

### **4. Content Persistence**
- Previously saved content automatically loads when editing the node
- Edit and re-save content as needed
- No content is ever lost - everything is retrievable
- Perfect for iterative content improvement

### **5. Manual Publishing**
- Use your preferred publishing tools (Hootsuite, Buffer, etc.)
- Copy content from Drupal fields to social platforms
- Schedule and publish when ready
- Maintain full control over publishing timing

---

## ♿ Accessibility Features

Social Summaries is built with accessibility in mind and follows WCAG 2.1 AA guidelines to ensure all users can effectively use the module.

### **Screen Reader Support**
- **ARIA Live Regions**: Status updates and error messages are announced to screen readers
- **Proper Labeling**: All form elements have descriptive labels and ARIA attributes
- **Role Definitions**: Interactive elements have proper ARIA roles (buttons, regions, status)
- **Focus Management**: Keyboard navigation is fully supported with proper focus indicators

### **Keyboard Navigation**
- **Tab Order**: Logical tab sequence through all interactive elements
- **Keyboard Shortcuts**: Standard keyboard interactions work as expected
- **Focus Indicators**: Clear visual focus indicators for keyboard users
- **Skip Links**: Easy navigation for keyboard users

### **Visual Accessibility**
- **Color Contrast**: Sufficient color contrast ratios for all text and UI elements
- **Text Scaling**: Interface scales properly with browser zoom settings
- **Loading States**: Clear visual and auditory feedback during content generation
- **Error Indicators**: Multiple ways to identify errors (visual, auditory, programmatic)

### **Form Accessibility**
- **Field Relationships**: Proper labeling relationships between form elements and their labels
- **Validation Messages**: Clear, descriptive error messages with proper ARIA attributes
- **Character Counters**: Live character counting with screen reader announcements
- **Required Fields**: Clear indication of required fields

### **Dynamic Content**
- **Status Announcements**: Real-time updates are announced to screen readers
- **Loading States**: Button states and progress indicators are properly communicated
- **Content Updates**: Generated content changes are announced appropriately
- **Error Handling**: Error states are clearly communicated to all users

### **Testing & Compliance**
- **Automated Testing**: Comprehensive accessibility tests ensure ongoing compliance
- **Screen Reader Testing**: Tested with popular screen readers (NVDA, JAWS, VoiceOver)
- **Keyboard Testing**: Full keyboard navigation testing
- **WCAG 2.1 AA**: Meets or exceeds WCAG 2.1 AA compliance standards

---

## 🔒 Permissions & Security

### User Permissions

- **`social_summaries.generate`** - Generate AI content using the interface
- **`social_summaries.configure`** - Access and modify configuration settings
- **`social_summaries.view_costs`** - View AI token/cost data
- **`social_summaries.view_usage`** - View AI usage statistics

### Security Features

- **Access Control**: All endpoints require proper permissions
- **Input Validation**: All parameters are validated and sanitized
- **Rate Limiting**: Built-in protection against API abuse
- **Secure API Storage**: Keys stored using Drupal's Key module
- **Error Handling**: Generic messages prevent information disclosure
- **CSRF Protection**: All forms include CSRF tokens
- **XSS Prevention**: All output is properly escaped

---

## 🛡️ Error Handling & Reliability

### Automatic Retry System
- **Exponential Backoff**: Failed requests are retried with increasing delays
- **Rate Limit Respect**: Intelligent handling of OpenAI rate limits
- **Connection Recovery**: Automatic retry for network connectivity issues
- **Configurable Retries**: Set maximum retry attempts and timeouts

### Error Management
- **User-Friendly Messages**: Clear, actionable error messages for users
- **Administrative Logging**: Detailed error logging for troubleshooting
- **Graceful Degradation**: System continues working even with API issues
- **Connection Testing**: Built-in validation of API configuration

---

## 📊 Bulk Processing & Rate Limiting

### Bulk Operations
- **Batch Processing**: Process multiple nodes with configurable batch sizes
- **Progress Tracking**: Real-time progress updates and completion statistics
- **Dry Run Mode**: Preview what would be processed without making API calls
- **Flexible Filtering**: Process by content type, date range, or custom criteria

### Intelligent Rate Limiting
- **Automatic Detection**: Monitors API usage and adjusts delays accordingly
- **Configurable Limits**: Set calls per minute/hour based on your API plan
- **Smart Delays**: Dynamic delays that respect OpenAI's rate limits
- **Usage Statistics**: Track API calls, costs, and rate limit status
- **Slow Down Warnings**: Alerts when approaching rate limits

---

---

## 🛣️ Roadmap

- Multilingual support
- Variant suggestions
- Direct publishing connectors
- UTM auto-tagging
- Image generation
- Advanced prompt template features (conditional logic, A/B testing)
- Enhanced accessibility features (high contrast mode, reduced motion support)

---

## 🧪 Testing & Quality Assurance

### Comprehensive Test Suite
The module includes extensive testing with 90%+ code coverage:

```bash
# Run all tests
./run-tests.sh

# Or with PHPUnit directly
vendor/bin/phpunit --testsuite=social_summaries

# Run specific test types
vendor/bin/phpunit tests/src/Unit/     # Unit tests
vendor/bin/phpunit tests/src/Kernel/   # Integration tests
vendor/bin/phpunit tests/src/Functional/ # End-to-end tests
```

### Test Coverage
- **Unit Tests**: Core logic, API integration, rate limiting
- **Kernel Tests**: Configuration, Drush commands, form handling
- **Functional Tests**: UI interactions, permissions, workflows
- **Accessibility Tests**: WCAG 2.1 AA compliance, screen reader support, keyboard navigation
- **JavaScript Tests**: Client-side accessibility features, ARIA attributes, focus management
- **CI/CD Integration**: Automated testing on every commit

See [TESTING.md](TESTING.md) for detailed testing information.

---

## 🤝 Contributing

We welcome contributions to improve Social Summaries:

- **Issue Reports**: Report bugs and feature requests on Drupal.org
- **Code Contributions**: Submit patches and new features
- **Testing**: Help improve test coverage and quality
- **Documentation**: Improve guides and examples
- **Templates**: Contribute new prompt templates and providers

### Development Guidelines
- Follow Drupal coding standards
- Include comprehensive tests for new features
- Update documentation for any changes
- Test thoroughly before submitting

---

## 📜 License

**GPL v2.0 or later**

This module is licensed under the GNU General Public License, version 2 or later. See the LICENSE file for details.

---

## 🆘 Support

- **Documentation**: Check this README and TESTING.md
- **Issues**: Report bugs on the Drupal.org issue queue
- **Security**: Report security issues privately (see SECURITY.md)
- **Community**: Join discussions on Drupal.org
