#!/bin/bash

# Social Summaries Test Runner
# This script runs the test suite for the Social Summaries module

echo "Running Social Summaries Test Suite..."
echo "=================================="

# Check if we're in the right directory
if [ ! -f "composer.json" ]; then
    echo "Error: composer.json not found. Please run this script from the module root directory."
    exit 1
fi

# Check if vendor directory exists
if [ ! -d "vendor" ]; then
    echo "Installing dependencies..."
    composer install
fi

# Run PHPUnit tests
echo "Running unit tests..."
vendor/bin/phpunit --testsuite=social_summaries --testdox

echo ""
echo "Test run completed!"
echo "For more detailed output, run: vendor/bin/phpunit --testsuite=social_summaries --verbose"
