<?php

declare(strict_types=1);

namespace Drupal\social_summaries\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * Attribute for declaring Social Summaries provider plugins.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class SocialSummariesProvider extends Plugin {

  /**
   * The plugin label.
   *
   * @var string
   */
  public string $label;

  /**
   * The plugin description.
   *
   * @var string
   */
  public string $description;

  /**
   * Constructs a SocialSummariesProvider attribute.
   */
  public function __construct(
    string $id,
    string $label = '',
    ?string $description = NULL,
    ?string $deriver = NULL,
  ) {
    parent::__construct($id, $deriver);
    $this->label = $label;
    $this->description = $description ?? '';
  }

}
