<?php

declare(strict_types=1);

namespace Drupal\social_summaries\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Form for filtering usage statistics.
 */
class UsageFilterForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'social_summaries_usage_filter';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $request = $this->getRequest();
    $current_platform = $request->query->get('platform', '');
    $current_date_from = $request->query->get('date_from', '');
    $current_date_to = $request->query->get('date_to', '');

    $form['#method'] = 'GET';
    $form['#action'] = Url::fromRoute('social_summaries.usage.log')->toString();

    $form['filters'] = [
      '#type' => 'container',
      '#attributes' => ['class' => ['form--inline', 'clearfix']],
    ];

    $platforms = [
      '' => $this->t('- All platforms -'),
      'summary' => $this->t('Summary'),
      'linkedin' => $this->t('LinkedIn'),
      'x' => $this->t('X (Twitter)'),
      'newsletter' => $this->t('Newsletter'),
      'facebook' => $this->t('Facebook'),
      'threads' => $this->t('Threads'),
    ];

    $form['filters']['platform'] = [
      '#type' => 'select',
      '#title' => $this->t('Platform'),
      '#options' => $platforms,
      '#default_value' => $current_platform,
      '#attributes' => ['name' => 'platform'],
    ];

    $form['filters']['date_from'] = [
      '#type' => 'date',
      '#title' => $this->t('From date'),
      '#default_value' => $current_date_from,
      '#attributes' => ['name' => 'date_from'],
    ];

    $form['filters']['date_to'] = [
      '#type' => 'date',
      '#title' => $this->t('To date'),
      '#default_value' => $current_date_to,
      '#attributes' => ['name' => 'date_to'],
    ];

    $form['filters']['actions'] = [
      '#type' => 'actions',
    ];

    $form['filters']['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Filter'),
    ];

    $form['filters']['actions']['reset'] = [
      '#type' => 'link',
      '#title' => $this->t('Reset'),
      '#url' => Url::fromRoute('social_summaries.usage.log'),
      '#attributes' => ['class' => ['button']],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    // This form uses GET method, so submission is handled by the URL.
  }

}
