<?php

declare(strict_types=1);

namespace Drupal\social_summaries\Provider;

/**
 * Interface for AI content generation providers.
 */
interface AiProviderInterface {

  /**
   * Generate content using the AI provider.
   *
   * @param array $messages
   *   Array of messages to send to the AI provider.
   * @param array $options
   *   Additional options for generation.
   *
   * @return array
   *   Generated content response.
   */
  public function generate(array $messages, array $options = []): array;

  /**
   * Get the provider name.
   *
   * @return string
   *   The provider name.
   */
  public function name(): string;

  /**
   * Get available models for this provider.
   *
   * @return array
   *   Array of available models.
   */
  public function models(): array;

}
