<?php

declare(strict_types=1);

namespace Drupal\social_summaries\Service;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Provides visibility utilities for Social Summaries.
 */
class VisibilityManager {

  /**
   * Config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected ConfigFactoryInterface $configFactory;

  /**
   * Constructor.
   */
  public function __construct(ConfigFactoryInterface $configFactory) {
    $this->configFactory = $configFactory;
  }

  /**
   * Gets effective visible platforms for a content type bundle.
   */
  public function getEffectiveVisiblePlatforms(string $bundle): array {
    $global = (array) ($this->configFactory->get('social_summaries.settings')->get('visible_platforms') ?? []);
    $bundle_config = $this->configFactory->get('social_summaries.bundle.' . $bundle);
    $override = (bool) ($bundle_config ? ($bundle_config->get('override') ?? FALSE) : FALSE);
    $enabled = (bool) ($bundle_config ? ($bundle_config->get('enabled') ?? TRUE) : TRUE);
    $bundle_visible = (array) ($bundle_config ? ($bundle_config->get('visible_platforms') ?? []) : []);

    // If the bundle is explicitly disabled, hide everything.
    if ($bundle_config && $enabled === FALSE) {
      return [];
    }

    if ($override) {
      // Filter out 0/falsey values while preserving keys; return values only.
      return array_values(array_filter($bundle_visible, static function ($v) {
        return $v !== 0 && $v !== FALSE && $v !== '';
      }));
    }

    return array_values($global);
  }

}
