<?php

declare(strict_types=1);

namespace Drupal\social_summaries\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Social Summaries provider plugin annotation object.
 *
 * @Annotation
 */
class SocialSummariesProvider extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public string $id;

  /**
   * The human-readable name of the provider.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A brief description of the provider.
   *
   * @var string|\Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The provider's API documentation URL.
   *
   * @var string
   */
  public string $api_documentation = '';

  /**
   * Whether this provider requires an API key.
   *
   * @var bool
   */
  public bool $requires_api_key = TRUE;

  /**
   * The default model for this provider.
   *
   * @var string
   */
  public string $default_model = '';

  /**
   * The maximum tokens supported by this provider.
   *
   * @var int
   */
  public int $max_tokens = 4096;

  /**
   * The default temperature for this provider.
   *
   * @var float
   */
  public float $default_temperature = 0.5;

}
