<?php

declare(strict_types=1);

namespace Drupal\social_summaries\Plugin\SocialSummariesProvider;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

// No custom discovery overrides; rely on DefaultPluginManager's discovery.

/**
 * Manages Social Summaries provider plugins.
 */
class SocialSummariesProviderManager extends DefaultPluginManager {

  /**
   * Constructs a SocialSummariesProviderManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/SocialSummariesProvider',
      $namespaces,
      $module_handler,
      'Drupal\\social_summaries\\Plugin\\SocialSummariesProvider\\SocialSummariesProviderInterface',
      'Drupal\\social_summaries\\Annotation\\SocialSummariesProvider'
    );

    $this->alterInfo('social_summaries_provider_info');
    $this->setCacheBackend($cache_backend, 'social_summaries_provider_plugins');
  }

  // Use parent's discovery implementation.

  /**
   * Gets available provider options for forms.
   *
   * @return array
   *   An array of provider options keyed by plugin ID.
   */
  public function getProviderOptions(): array {
    $options = [];
    foreach ($this->getDefinitions() as $plugin_id => $definition) {
      $options[$plugin_id] = $definition['label'];
    }
    return $options;
  }

  /**
   * Gets the default provider plugin ID.
   *
   * @return string
   *   The default provider plugin ID.
   */
  public function getDefaultProvider(): string {
    $definitions = $this->getDefinitions();
    return array_key_first($definitions) ?: 'openai';
  }

}
