# Socialfeed Module

Provides a Drupal block system integration for displaying social media feeds
from Facebook, Twitter, and Instagram.

## Overview

The Socialfeed module enables site administrators to fetch and display social
media content directly on their Drupal site using blocks. Each social platform
has dedicated configuration forms and dedicated blocks for customizable display
options.

## Features

### Facebook

- Display posts from your Facebook profile
- Filter by post type (photos, videos, text, etc.)
- Configurable post count
- Display post dates
- Customizable block display

### Instagram

IMPORTANT: Starting on December 4th, 2024, Instagram Basic Display API will no
longer be available. All requests to Basic Display will fail after this date.
Please migrate to Instagram Graph API.
See: https://developers.facebook.com/blog/post/2024/09/04/update-on-instagram-basic-display-api/

- Display media from Instagram Professional (Creator/Business) accounts via the
  Instagram Graph API
- Support for images, videos, and carousel albums
- Configurable post count
- Optional post link display
- Multiple post type templates (image, video, carousel)

Migration steps if you previously used Basic Display with a personal account:

1. Convert your Instagram account to a Creator or Business account
2. Update API credentials in the Socialfeed configuration
3. Re-authenticate via the Instagram settings form

### Twitter

- Display latest tweets from your profile
- Show tweet dates
- Configurable tweet count
- Works on live sites (requires Twitter API access)

## Requirements

- **PHP**: 8.3 or higher (Drupal 11 minimum requirement)
- **Drupal**: 11.x (actively maintained)
- **Dependencies**:
    - `abraham/twitteroauth` (^4.0)
    - `facebook/php-business-sdk` (^14.0)
    - `nesbot/carbon` (^2.59)

### Drupal 11 Compatibility

This module is fully compatible with Drupal 11 and actively maintained for the
latest Drupal version. The module uses modern Drupal 11 APIs including:

- `TranslatableMarkup` for translations (replaces deprecated `t()` function)
- Contemporary plugin and service architecture
- Drupal 11-compatible dependency versions

### Development Environment

> Note: This project assumes you are using DDEV for local development. All
> commands below use DDEV syntax. If you are not using DDEV, replace
`ddev composer` with `composer`, and `ddev drush` with `drush`.

## Installation

1. Download or require the module via Composer:
   ```bash
   ddev composer require drupal/socialfeed
   ```

2. Install the module using Drupal's module administration interface or via
   Drush:
   ```bash
   ddev drush en socialfeed -y
   ```

3. Clear caches:
   ```bash
   ddev drush cache:rebuild
   ```

## Configuration

### Initial Setup

Access the Socialfeed configuration page at **Admin > Configuration > Services >
Socialfeed** (`/admin/config/services/socialfeed`).

### Platform Configuration

Each social media platform has its own configuration form:

- **Facebook Settings Form** - Configure Facebook API credentials and fetching
  options
- **Instagram Settings Form** - Configure Instagram API credentials and
  authentication
- **Twitter Settings Form** - Configure Twitter API credentials (OAuth)

### Using the Blocks

Once configured, use Drupal's block system to add social media feed blocks to
your site:

1. Go to **Structure > Block Layout**
2. Add one of the available blocks:
    - **Facebook Post Block** - Display Facebook feed
    - **Instagram Post Block** - Display Instagram feed
    - **Twitter Post Block** - Display Twitter feed
3. Configure block settings (number of posts, display options, etc.)
4. Save and place the block in your desired region

## Block Configuration Options

Each block provides configurable options:

- Number of posts to display
- Display options specific to each platform
- Caching settings

## Theming

The module provides theme templates for customizing post display. Custom theme
templates are located in the `templates/` directory.

Available theme hooks:

- `socialfeed_facebook_post` - Facebook post display with status_type variants
- `socialfeed_twitter_post` - Twitter post display
- `socialfeed_instagram_post_image` - Instagram image post
- `socialfeed_instagram_post_video` - Instagram video post
- `socialfeed_instagram_post_carousel_album` - Instagram carousel display

### Custom Styling

The module outputs plain text and semantic HTML by default. CSS customization is
straightforward for developers familiar with CSS.

## Permissions

The module defines the following permission:

- `administer socialfeed` - Access Socialfeed configuration and administration

## Known Limitations

### Twitter API v1.1 (Deprecated by Twitter)

The module currently uses Twitter API v1.1 endpoints via `abraham/twitteroauth`.
Twitter has deprecated this API.

- Current Status: Still functional but not recommended for new projects
- Recommendation: Consider migrating to Twitter API v2 in future versions
- Workaround: Continue using current endpoints; migration would require library
  changes

## Troubleshooting

### Twitter API Issues

- Twitter feeds may not work in local development environments
- Ensure your site is accessible via HTTPS and has a valid domain for production
  use

### Instagram API Deprecation (December 4, 2024)

**Critical Update**: Instagram Basic Display API is no longer available as of
December 4, 2024. If your feeds are not loading:

- **Action Required**: Migrate to the Instagram Graph API
- Your account must be a Creator or Business account (personal accounts no
  longer supported)
- Update your API credentials in the Socialfeed configuration form
- Re-authenticate by visiting the Instagram Authentication page

For detailed migration information,
see: https://developers.facebook.com/blog/post/2024/09/04/update-on-instagram-basic-display-api/

### Instagram OAuth

- Instagram uses OAuth for authentication with Professional accounts
- Visit the Instagram Authentication page after configuring credentials

### API Credentials

- Each platform requires API credentials (keys, tokens, etc.)
- Refer to the official platform documentation for obtaining credentials:
    - [Facebook Developers](https://developers.facebook.com/)
    - [Instagram Graph API](https://developers.facebook.com/docs/instagram-graph-api)
    - [Twitter Developer Portal](https://developer.twitter.com/)

## API Reference

### Services

- **FacebookPostCollectorFactory** - Creates Facebook post collector instances
- **FacebookPostCollector** - Fetches posts from Facebook
- **TwitterPostCollectorFactory** - Creates Twitter post collector instances
- **TwitterPostCollector** - Fetches posts from Twitter
- **InstagramPostCollectorFactory** - Creates Instagram post collector instances
- **InstagramPostCollector** - Fetches posts from Instagram
- **InstagramApiService** - Handles Instagram API interactions

### Forms

- **FacebookSettingsForm** - Facebook configuration
- **TwitterSettingsForm** - Twitter configuration
- **InstagramSettingsForm** - Instagram configuration

## Dependencies & Compatibility

**Current Dependency Status:**

- abraham/twitteroauth (^4.0) - D11 Compatible
- facebook/php-business-sdk (>=14.0) - D11 Compatible
- nesbot/carbon (^2.59 || ^3.0) - D11 Compatible

All dependencies are tested and compatible with Drupal 11 (PHP 8.3+).

## License

GPL-2.0+

## Support

- **Issues**: https://www.drupal.org/project/issues/socialfeed
- **Repository**: https://git.drupalcode.org/project/socialfeed
- **Project Page**: https://www.drupal.org/project/socialfeed
