<?php
/**
 * @file
 * Admin page callback file for the socialloginandsocialshare module.
 */
/**
 * Implements Admin setting for the socialloginandsocialshare module.
 */
function socialloginandsocialshare_admin_settings(&$form_state) {
  /**
   * inline script to aurodetect the connection method and verify API keys.
   */
  global $base_url;
  if (!variable_get('socialloginandsocialshare_apikey', FALSE) || !variable_get('socialloginandsocialshare_apisecret', FALSE)) {
    drupal_set_message(t('To activate the Social Login, insert LoginRadius API Key and Secret in the Social Login section below. Social Sharing do not require API Key and Secret.'), 'warning');
  }
  drupal_add_css(drupal_get_path('module', 'socialloginandsocialshare') . '/socialloginandsocialshare.admin.css');
  $group = 'setup';
  $get_socialloginandsocialshare = '';
  if (!variable_get('socialloginandsocialshare_apikey', FALSE)) {
    $get_socialloginandsocialshare = t('For creating a Social Login account, please visit <a href="@get_socialloginandsocialshare" target="_blank">LoginRadius</a>', array('@get_socialloginandsocialshare' => 'http://ish.re/4'));
  }
  $thanks_text = t('To activate the plugin, you will need to first configure it (manage your desired social networks, etc.) from your LoginRadius account. If you do not have an account,
   click <a href="@loginradius" target="_blank">here</a> and create one for FREE!<br/>We also offer Social Plugins for
   <a href="@joomla" target="_blank">Joomla</a>, <a href="@wordpress" target="_blank">Wordpress</a>,
   <a href="@vbulletin" target="_blank">vBulletin</a>, <a href="@vanillaforum" target="_blank">VanillaForum</a>,
   <a href="@magento" target="_blank">Magento</a>, <a href="@oscommerce" target="_blank">OSCommerce</a>,
   <a href="@prestashop" target="_blank">Prestashop</a>, <a href="@xcart" target="_blank">X-Cart</a>,
   <a href="@zencart" target="_blank">Zen-Cart</a>, <a href="@phpbb" target="_blank">phpBB</a>,
   <a href="@smf" target="_blank">SMF</a> and <a href="@dotnetnuke" target="_blank">DotNetNuke</a>.<br/>
   <a href="@loginradius" target="_blank"><br/><input class="form-submit" type="button" value="Set up my FREE account!"></a>
   (<a href="@get_sociallogin" target="_blank">How to set up an account?</a>)',
    array(
      '@loginradius' => 'http://ish.re/4',
      '@joomla' => 'http://ish.re/ALT8',
      '@wordpress' => 'http://ish.re/ADDT',
      '@vbulletin' => 'http://ish.re/ALTA',
      '@vanillaforum' => 'http://ish.re/ALUN',
      '@magento' => 'http://ish.re/ALT6',
      '@oscommerce' => 'http://ish.re/ALTC',
      '@prestashop' => 'http://ish.re/ALTD',
      '@xcart' => 'http://ish.re/ALUL',
      '@zencart' => 'http://ish.re/ALUM',
      '@phpbb' => 'http://ish.re/A7MH',
      '@smf' => 'http://ish.re/A7MF',
      '@dotnetnuke' => 'http://ish.re/ALUP',
      '@get_sociallogin' => 'http://ish.re/ATM4'
    ));
  $form['thanks_block'] = array(
    '#type' => 'fieldset',
    '#description' => $thanks_text,
  );
  $form[$group] = array(
    '#type' => 'fieldset',
    '#title' => t('LoginRadius API settings'),
    '#id' => 'setup',
    '#collapsible' => TRUE,
    '#description' => $get_socialloginandsocialshare,
  );

  $form[$group]['socialloginandsocialshare_apikey'] = array(
    '#type' => 'textfield',
    '#title' => t('API Key'),
    '#default_value' => variable_get('socialloginandsocialshare_apikey', ''),
    '#description' => t('To activate the plugin, insert LoginRadius API Key (<a href="@get_socialloginandsocialshare" target="_blank">How to get it?</a>)', array('@get_socialloginandsocialshare' => 'http://ish.re/9VBI')),
  );
  $form[$group]['socialloginandsocialshare_apisecret'] = array(
    '#type' => 'textfield',
    '#title' => t('API Secret'),
    '#default_value' => variable_get('socialloginandsocialshare_apisecret', ''),
    '#description' => t('To activate the plugin, insert LoginRadius API Secret (<a href="@get_socialloginandsocialshare" target="_blank">How to get it?</a>)', array('@get_socialloginandsocialshare' => 'http://ish.re/9VBI')),
  );
  $group = 'basic_setting';
  $form[$group] = array(
    '#type' => 'fieldset',
    '#title' => t('Social Login basic settings'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$group]['interface']['socialloginandsocialshare_disable_traditional_login'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want users to log in using Social Login only?'),
    '#default_value' => variable_get('socialloginandsocialshare_disable_traditional_login', 0),
    '#options' => array(
      1 => t('Yes, I want to disable the  Drupal native login form.(In this case, admin can login with his/her linked social account or via /user [example(clean url): site-url/user or example(not clean url): site-url/?q=user])'),
      0 => t('No, I want my users to have both options at their disposal'),
    ),
  );
  $form[$group]['socialloginandsocialshare_display_username'] = array(
    '#type' => 'radios',
    '#title' => t('How would you like Username to be created? Select your desired composition rule for Username.'),
    '#default_value' => variable_get('socialloginandsocialshare_display_username', 0),
    '#options' => array(
      0 => t('Firstname Lastname [Ex: John Doe]'),
      1 => t('Firstname-Lastname [Ex: John-Doe]'),
      2 => t('Email Address [Ex: johndoe@abc.com]'),
    ),
  );
  $form[$group]['socialloginandsocialshare_userlogin_redirect'] = array(
    '#type' => 'radios',
    '#title' => t('Redirection settings after login'),
    '#default_value' => variable_get('socialloginandsocialshare_userlogin_redirect', 0),
    '#options' => array(
      0 => t('Redirect to same page of site'),
      1 => t('Redirect to profile page of site'),
      2 => t('Redirect to custom page of site (If you want user to be redirected to specific URL after Login)'),
    ),
  );
  $form[$group]['socialloginandsocialshare_userlogin_redirect']['socialloginandsocialshare_custom_redirection'] = array(
    '#type' => 'textfield',
    '#weight' => 50,
    '#default_value' => variable_get('socialloginandsocialshare_custom_redirection', ''),
  );
  $form[$group]['socialloginandsocialshare_userregister_redirect'] = array(
    '#type' => 'radios',
    '#title' => t('Redirection settings after registration'),
    '#default_value' => variable_get('socialloginandsocialshare_userregister_redirect', 0),
    '#options' => array(
      0 => t('Redirect to same page of site'),
      1 => t('Redirect to profile page of site'),
      2 => t('Redirect to custom page of site (If you want user to be redirected to specific URL after Registeration)'),
    ),
  );
  $form[$group]['socialloginandsocialshare_userregister_redirect']['socialloginandsocialshare_custom_register_redirection'] = array(
    '#type' => 'textfield',
    '#weight' => 50,
    '#default_value' => variable_get('socialloginandsocialshare_custom_register_redirection', ''),
  );
  $group = 'account_linking';
  $form[$group] = array(
    '#type' => 'fieldset',
    '#title' => t('Social account linking settings'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$group]['socialloginandsocialshare_account_linking'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want to enable Social Account Linking at User Profile Page?'),
    '#default_value' => variable_get('socialloginandsocialshare_account_linking', 1),
    '#options' => array(
      1 => t('YES'),
      0 => t('NO'),
    )
  );
  $form[$group]['linking']['socialloginandsocialshare_identity_label_string'] = array(
    '#type' => 'textfield',
    '#title' => t('What header text do you want to display to users for the social account linking functionality?'),
    '#default_value' => variable_get('socialloginandsocialshare_identity_label_string', 'Link to an existing social account'),
    '#description' => t('This text will be displayed just above Social Login add more identities interface.'),
  );
  // Submit handler.
  $form['#submit'][] = 'socialloginandsocialshare_admin_settings_submit';
  $form['actions']['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Save configuration'),
  );
  return $form;
}

/**
 * Validate admin_settings.
 */
function socialloginandsocialshare_admin_settings_validate($form, &$form_state) {
  if (!class_exists(LoginRadius)) {
    include 'socialloginandsocialshare.loginradius.inc';
  }
  unset($_SESSION['messages']['warning']);
  unset($_SESSION['messages']['error']);
  $apikey = trim($form_state['values']['socialloginandsocialshare_apikey']);
  $apisecret = trim($form_state['values']['socialloginandsocialshare_apisecret']);
  $api_handler = variable_get('socialloginandsocialshare_api_handler', '');
  //trim($form_state['values']['socialloginandsocialshare_api_handler']);
  if (in_array('curl', get_loaded_extensions()) AND function_exists('curl_exec')) {
    variable_set('socialloginandsocialshare_api_handler', 1);
  }
  else {
    variable_set('socialloginandsocialshare_api_handler', 0);
  }
  $userauth = loginradius_get_auth($apikey, $apisecret, $api_handler);
  if (empty($apikey) || empty($apisecret)) {

  }
  elseif (trim($apikey) == trim($apisecret)) {
    drupal_set_message(t('API Key and Secret cannot be same. Please paste correct API Key and Secret from your LoginRadius account in the corresponding fields'), 'error');
  }
  elseif (!socialloginandsocialshare_isvalid_apikey($apikey)) {
    drupal_set_message(t('Your LoginRadius API key is not valid, please correct it or contact LoginRadius support at <a href="@get_socialloginandsocialshare" target="_blank">www.Loginradius.com</a>', array('@get_socialloginandsocialshare' => 'http://www.Loginradius.com/')), 'error');

  }
  elseif (!socialloginandsocialshare_isvalid_apikey($apisecret)) {
    drupal_set_message(t('Your LoginRadius API Secret is not valid, please correct it or contact LoginRadius support at <a href="@get_socialloginandsocialshare" target="_blank">www.Loginradius.com</a>', array('@get_socialloginandsocialshare' => 'http://www.Loginradius.com/')), 'error');

  }
  elseif ($userauth == "connection error") {
    drupal_set_message(t('Your API connection method "@handler" is not working properly. try to change API connection method and verify your API settings.', array('@handler' => ($api_handler == 1 ? 'CURL' : 'FSOCKOPEN'))), 'error');

  }
  elseif ($userauth == "service connection timeout" || $userauth == "timeout") {
    drupal_set_message(t('Uh oh, looks like something went wrong. Try again in a sec!'), 'error');
  }
}

function socialloginandsocialshare_admin_settings_submit($form, &$form_state) {
  foreach ($form_state['values'] as $key => $value) {
    if (is_array($value) && isset($form_state['values']['array_filter'])) {
      $value = array_keys(array_filter($value));
    }
    variable_set($key, $value);
  }
  $settings = array(
    'socialloginandsocialshare_label_string' => 'Login with Social ID',
    'socialloginandsocialshare_interface_size' => '0',
    'socialloginandsocialshare_attach_login_form' => '1',
    'socialloginandsocialshare_loginpage_position' => '1',
    'socialloginandsocialshare_registerpage_position' => '1',
    'socialloginandsocialshare_showicon_location' => '0',
    'socialloginandsocialshare_force_registration' => '1',
    'socialloginandsocialshare_email_required' => '1',
    'socialloginandsocialshare_emailrequired_popup_top' => 'You are trying to connect with @provider',
    'socialloginandsocialshare_emailrequired_popup_text' => 'Unfortunately we could not retrieve your email from your @provider account Please enter your email in the form below in order to continue.',
    'socialloginandsocialshare_emailrequired_popup_wrong' => 'This email is already registered. Please enter another email or link this account via account linking on your profile page',
    'socialloginandsocialshare_send_user_credentials' => '1',
  );
  foreach ($settings as $key => $values) {
    if (!variable_get($key, FALSE) && variable_get($key, '')!= '0') {
      variable_set($key, $values);
    }
  }
  if (module_exists('profile')) {
    module_load_include('inc', 'socialloginandsocialshare', 'socialloginandsocialshare.field');
    if (isset($form_state['values']['socialloginandsocialshare_user_fields'])) {
      variable_set('socialloginandsocialshare_user_profile', array_filter($form_state['values']['socialloginandsocialshare_user_profile']));
    }
  }
  drupal_set_message(t('The configuration options have been saved.'));
  // Clear the cached pages and blocks.
  cache_clear_all();
  menu_rebuild();
}

function socialloginandsocialshare_advance_settings_form(&$form_state) {
  global $base_url;
  drupal_add_css(drupal_get_path('module', 'socialloginandsocialshare') . '/socialloginandsocialshare.admin.css');
  $my_path = drupal_get_path('module', 'socialloginandsocialshare');
  $image_url = "$base_url/$my_path/images/loading.gif";
  drupal_add_js("
  function loginRadiusVerifyKeys(){
    var socialloginandsocialshare_verify_api_keys = function (data) {
	if(data.msg == 'key'){
	  $('#loginradius_apiresponse').html('<span style=color:red;width:auto>Your LoginRadius API key is not valid, please correct it or contact LoginRadius support at <a href=http://www.Loginradius.com/ target=_blank>www.Loginradius.com</a>.</span>');
	}
	else if(data.msg == 'secret') {
	  $('#loginradius_apiresponse').html('<span style=color:red;width:auto>Your LoginRadius API Secret is not valid, please correct it or contact LoginRadius support at <a href=http://www.Loginradius.com/ target=_blank>www.Loginradius.com</a>.</span>');
	}
	else if(data.msg == 'samekeys') {
	 $('#loginradius_apiresponse').html('<span style=color:red;width:auto>API Key and Secret cannot be same. Please paste correct API Key and Secret from your LoginRadius account in the corresponding fields.</span>');
	}
	else if(data.msg == 'incorrect key') {
	  $('#loginradius_apiresponse').html('<span style=color:red;width:auto>Your LoginRadius API key or Secret is not valid, please correct it or contact LoginRadius support at <a href=http://www.Loginradius.com/ target=_blank>www.Loginradius.com</a>.</span>');
	}

	else if(data.msg == 'working') {
	  $('#loginradius_apiresponse').html('<span style=color:green;width:auto>Your API Key and Secret are valid. Please save the changes.</span>');
	}
	else if(data.msg == 'connection'){
	  $('#loginradius_apiresponse').html('<span style=color:red;width:auto>Problem in communicating LoginRadius API. Please check if one of the API Connection method mentioned above is working</span>');
	}
	else if(data.msg== 'service connection timeout' || data.msg == 'timeout'){
	  $('#loginradius_apiresponse').html('<span style=color:red;width:auto>Uh oh, looks like something went wrong. Try again in a sec!</span>');
	}
  }
  $('#loginradius_apiresponse').html('<img src=" . $image_url . "  width=20 height=20 alt=lodaing style=float:left;margin-right:5px;/><span style=color:blue;width:auto>Please wait. This may take a few minutes</span');
   if($('#edit-socialloginandsocialshare-api-handler-0').is(':checked')) { handler =0; }
   else {handler =1;}
  $.ajax({
    type: 'POST',
    url:  '" . url('socialloginandsocialshare/verify_api_keys') . "',
	dataType: 'json',
    success: socialloginandsocialshare_verify_api_keys,
	 data: {
			   api_handler: handler,
		  },});}", "inline", "header");
  $group = 'interface_settings';
  $form[$group] = array(
    '#type' => 'fieldset',
    '#title' => t('Social Login interface customization'),
    '#id' => 'interface_settings',
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$group]['socialloginandsocialshare_api_handler'] = array(
    '#type' => 'radios',
    '#title' => t('What API connection method do you prefer for enabling API communication?'),
    '#default_value' => variable_get('socialloginandsocialshare_api_handler', 0),
    '#options' => array(
      0 => t('FSOCKOPEN (Default drupal_http_request() connection method. <b>Recommended!</b>)'),
      1 => t('CURL (Alternative API connection method, in case default method is not working properly.)'),
    ),
  );
  $form[$group]['checkApikeys'] = array(
    '#type' => 'item',
    '#value' => '<input type="button" name="verify_keys" value="Verify API Settings" onclick= "loginRadiusVerifyKeys();"  style=float:left;margin-right:40px;margin-bottom:1em;/><div id=loginradius_apiresponse></div>',
  );
  $form[$group]['socialloginandsocialshare_label_string'] = array(
    '#type' => 'textfield',
    '#title' => t('What text do you want to display above the Social Login interface?'),
    '#default_value' => variable_get('socialloginandsocialshare_label_string', 'Login with Social ID'),
    '#description' => t('Leave empty for no text'),
  );
  $form[$group]['socialloginandsocialshare_interface_size'] = array(
    '#type' => 'radios',
    '#title' => t('Select the icon size to use in the Social Login interface'),
    '#default_value' => variable_get('socialloginandsocialshare_interface_size', 1),
    '#options' => array(
      0 => t('Small'),
      1 => t('Medium'),
    ),
  );

  $form[$group]['socialloginandsocialshare_interface_columns'] = array(
    '#type' => 'textfield',
    '#title' => t('How many social icons would you like to be displayed per row?'),
    '#size' => 7,
    '#default_value' => variable_get('socialloginandsocialshare_interface_columns', ''),
  );
  $form[$group]['socialloginandsocialshare_interface_bgcolor'] = array(
    '#type' => 'textfield',
    '#title' => t('What background color would you like to use for the Social Login interface?'),
    '#default_value' => variable_get('socialloginandsocialshare_interface_bgcolor', ''),
    '#description' => t('Leave empty for transparent. You can enter hexa-decimal code as well as name of the color.'),
  );
  $group = 'interface_display_settings';
  $form[$group] = array(
    '#type' => 'fieldset',
    '#title' => t('Social Login interface display settings'),
    '#id' => 'interface_display_settings',
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$group]['interface']['socialloginandsocialshare_attach_login_form'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want to show the Social Login interface on the user login block?'),
    '#default_value' => variable_get('socialloginandsocialshare_attach_login_form', 1),
    '#options' => array(
      1 => t('YES'),
      0 => t('NO'),
    ),
  );
  $form[$group]['interface']['socialloginandsocialshare_loginpage_position'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want to show the Social Login interface with Drupal`s native login form?'),
    '#default_value' => variable_get('socialloginandsocialshare_loginpage_position', 1),
    '#options' => array(
      1 => t('YES'),
      0 => t('NO'),
    ),
  );
  $form[$group]['interface']['socialloginandsocialshare_registerpage_position'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want to show the Social Login interface with Drupal`s native user registration form?'),
    '#default_value' => variable_get('socialloginandsocialshare_registerpage_position', 1),
    '#options' => array(
      1 => t('YES'),
      0 => t('NO'),
    ),
  );
  $form[$group]['interface']['socialloginandsocialshare_showicon_location'] = array(
    '#type' => 'radios',
    '#title' => t('How do you want the Social Login interface to be displayed on your Drupal traditional registration/login form?'),
    '#default_value' => variable_get('socialloginandsocialshare_showicon_location', 0),
    '#options' => array(
      0 => t('Above the native registration/login form'),
      1 => t('Below the native registration/login form'),
    ),
  );
  $group = 'user_settings';
  $form[$group] = array(
    '#type' => 'fieldset',
    '#title' => t('Social Login user settings'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$group]['socialloginandsocialshare_enable_user_registration'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want to enable Social Login functionality when the Administrators only option is checked?'),
    '#default_value' => variable_get('socialloginandsocialshare_enable_user_registration', 0),
    '#options' => array(
      1 => t('Yes'),
      0 => t('No'),
    ),
  );
  $form[$group]['socialloginandsocialshare_force_registration'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want users to get registered automatically or have them manually complete the registration process?'),
    '#default_value' => variable_get('socialloginandsocialshare_force_registration', 1),
    '#options' => array(
      1 => t('Automatically register a user and create a new user account'),
      0 => t('Let the user submit the user registration form after social login process.(Users will be redirected to registration page with user fields auto filled and users finally submit the form to create an account with your website.)'),
    ),
  );
  $form[$group]['socialloginandsocialshare_email_required'] = array(
    '#type' => 'radios',
    '#title' => t('A few ID providers do not supply user email IDs as part of user profile data. Do you want users to provide their email IDs before completing the registration process?'),
    '#default_value' => variable_get('socialloginandsocialshare_email_required', 1),
    '#options' => array(
      1 => t('YES, get real email IDs from the users (Ask users to enter their email IDs in a pop-up)'),
      0 => t('NO, just auto-generate random email IDs for the users'),
    )
  );
  $form[$group]['socialloginandsocialshare_emailrequired_popup_top'] = array(
    '#type' => 'textarea',
    '#title' => t('Please enter the title of the pop-up asking users to enter their email address'),
    '#rows' => 2,
    '#default_value' => variable_get('socialloginandsocialshare_emailrequired_popup_top', 'You are trying to connect with @provider'),
    '#description' => t('You may use @provider, it will be replaced by the Provider name.'),
  );
  $form[$group]['socialloginandsocialshare_emailrequired_popup_text'] = array(
    '#type' => 'textarea',
    '#title' => t('Please enter the message to be displayed to the user in the pop-up asking for their email address'),
    '#rows' => 2,
    '#default_value' => variable_get('socialloginandsocialshare_emailrequired_popup_text', 'Unfortunately we could not retrieve your email from your @provider account Please enter your email in the form below in order to continue.'),
    '#description' => t('You may use @provider, it will be replaced by the Provider name.'),
  );
  $form[$group]['socialloginandsocialshare_emailrequired_popup_wrong'] = array(
    '#type' => 'textarea',
    '#title' => t('Please enter the message to be shown to the user in case of an already registered email'),
    '#rows' => 2,
    '#default_value' => variable_get('socialloginandsocialshare_emailrequired_popup_wrong', 'This email is already registered. Please enter another email or link this account via account linking on your profile page'),
  );
  $form[$group]['socialloginandsocialshare_send_user_credentials'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want to send a welcome email to new users after successful registration?'),
    '#default_value' => variable_get('socialloginandsocialshare_send_user_credentials', 1),
    '#options' => array(
      1 => t('YES'),
      0 => t('NO'),
    ),
    '#description' => t('Note: It will work only with networks which give email address like Facebook, linkedin.'),
  );
  $form[$group]['socialloginandsocialshare_email_content'] = array(
    '#type' => 'textarea',
    '#title' => t('Edit the welcome e-mail messages sent to new member accounts'),
    '#default_value' => socialloginandsocialshare_email_content_text(),
    '#rows' => 10,
  );
  $form[$group]['socialloginandsocialshare_update_profile'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want to update the user profile data in your database everytime a user logs into your website?'),
    '#default_value' => variable_get('socialloginandsocialshare_update_profile', 0),
    '#options' => array(
      1 => t('YES'),
      0 => t('NO'),
    )
  );
  $group = 'fieldmap';
  if (module_exists('profile')) {
    $description = t('Configure your user fields from <strong> PROFILES MODULE FIELD MAPPING </strong>section. Each of your fields that are attached to users are listed below. Map social provider data to field by choosing from select list.');
  }
  else {
    $description = t('<strong>Please enable PROFILE module form modules section for enable field mapping.</strong>');
  }
  $form[$group] = array(
    '#type' => 'fieldset',
    '#title' => t('Social Login field mapping'),
    '#description' => $description,
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  if (module_exists('profile')) {
    module_load_include('inc', 'socialloginandsocialshare', 'socialloginandsocialshare.field');
    $form[$group]['socialloginandsocialshare_user_profile'] = array(
      '#type' => 'fieldset',
      '#tree' => TRUE,
      '#weight' => 5,
    );
    $properties = socialloginandsocialshare_user_properties(TRUE);
    $property_options = array('' => t('- Do not import -'));
    foreach ($properties as $property => $property_info) {
      $property_options[$property] = '[' . $property . '] ' . $property_info['label'];
    }
    $field_defaults = variable_get('socialloginandsocialshare_user_profile', array());
    $field_select = array(
      '#type' => 'select',
      '#options' => $property_options,
    );
    $profile_fields = socialloginandsocialshare_profile_fields();
    foreach ($profile_fields as $profile_name => $profile_field) {
      $form[$group]['socialloginandsocialshare_user_profile'][$profile_name] = $field_select;
      $form[$group]['socialloginandsocialshare_user_profile'][$profile_name]['#title'] = t($profile_field['title']);
      $form[$group]['socialloginandsocialshare_user_profile'][$profile_name]['#default_value'] = isset($field_defaults[$profile_name]) ? $field_defaults[$profile_name] : '';
    }
  }
  $form[$group] = array(
    '#type' => 'fieldset',
    '#title' => t('Debug'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$group]['socialloginandsocialshare_debug_mode'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want to enable debugging mode?'),
    '#default_value' => variable_get('socialloginandsocialshare_debug_mode', 0),
    '#options' => array(
      1 => t('YES'),
      0 => t('NO'),
    )
  );
  return system_settings_form($form);
}

function socialloginandsocialshare_sharebar_settings_form(&$form_state) {
  $external_js = 'http://code.jquery.com/jquery-1.8.3.js';
  drupal_add_js('document.write(unescape("%3Cscript src=\'' . $external_js . '\' type=\'text/javascript\'%3E%3C/script%3E"));', 'inline');
  $external_js = 'http://code.jquery.com/ui/1.10.0/jquery-ui.js';
  drupal_add_js('document.write(unescape("%3Cscript src=\'' . $external_js . '\' type=\'text/javascript\'%3E%3C/script%3E"));', 'inline');
  drupal_add_js(drupal_get_path('module', 'socialloginandsocialshare') . '/js/socialloginandsocialshare.js');
  drupal_add_css(drupal_get_path('module', 'socialloginandsocialshare') . '/socialloginandsocialshare.admin.css');
  drupal_add_js('jQuery(document).ready(function() {
        var horizontal_image="' . variable_get("socialloginandsocialshare_share_horizontal_images", "") . '";
		var vertical_image="' . variable_get("socialloginandsocialshare_share_vertical_images", "") . '";
		if(horizontal_image == 8 || horizontal_image == 9) {
		  counter_horizntal_show();
		}
		else {
		  sharing_horizonatl_show();
		 if(horizontal_image == 2 || horizontal_image == 3) {
        sharing_simplehorizonatl_show();
      } 
		}
		if(vertical_image == 6 || vertical_image == 7) {
		  counter_vertical_show();
		 
		}
		else  {
		   sharing_vertical_show();
		   
		}
	var selected_theme = "' . variable_get("socialloginandsocialshare_selected_share_interface", "") . '";
	if(selected_theme == "vertical"){
	  hidden_horizontal_widget();
	}
	else {
	  display_horizontal_widget();
	}
  });', 'inline', 'header');
  $my_path = drupal_get_path('module', 'socialloginandsocialshare');
  global $base_url;
  $group = 'share';
  $form[$group] = array(
    '#type' => 'fieldset',
    '#title' => t('BASIC SOCIAL SHARE SETTINGS'),
  );
  $form[$group]['socialloginandsocialshare_share_horizontal'] = array(
    '#type' => 'item',
    '#prefix' => '<div><b>' . t('
    <div class="description">Please select the Social Sharing widget, Horizontal and vertical widgets can be enabled simultaneously.</div>') . '</b></div>',
    '#value' => '<div id="lr_tabs">
    <a href=javascript:void(0) id=socialloginandsocialshare_horizontal onclick = display_horizontal_widget();>' . check_plain(t('Horizontal')) . '</a>' . '<a href=javascript:void(0) onclick = hidden_horizontal_widget(); id=socialloginandsocialshare_veritical>' . check_plain(t('Vertical')) . '</a>',
  );

  $form[$group]['socialloginandsocialshare_selected_share_interface'] = array(
    '#type' => 'hidden',
    '#title' => t('selected share interface'),
    '#suffix' => '</div><div id=lrsharing_divwhite></div><div id=lrsharing_divgrey></div><div id="show_horizontal_block">',
    '#default_value' => variable_get('socialloginandsocialshare_selected_share_interface', ''),
  );
  $form[$group]['socialloginandsocialshare_enable_horizontal_share'] = array(
    '#type' => 'radios',
    '#attributes' => array('class' => 'socialloginandsocialshare_enable_horizontal_share'),
    '#title' => t('Do you want to enable Horizontal Social Sharing for your website?'),
    '#default_value' => variable_get('socialloginandsocialshare_enable_horizontal_share', 0),
    '#options' => array(
      1 => t('YES'),
      0 => t('NO'),
    )
  );
  $form[$group]['socialloginandsocialshare_enable_vertical_share'] = array(
    '#type' => 'radios',
    '#title' => t('Do you want to enable Vertical Social Sharing for your website?'),
    '#attributes' => array('class' => 'socialloginandsocialshare_enable_vertical_share'),
    '#default_value' => variable_get('socialloginandsocialshare_enable_vertical_share', 0),
    //'#prefix' => '<div id=lrsharing_divwhite></div><div id=lrsharing_divgrey></div><div id="show_horizontal_block">',
    '#options' => array(
      1 => t('YES'),
      0 => t('NO'),
    )
  );
  $form[$group]['socialloginandsocialshare_share_horizontal_images'] = array(
    '#type' => 'radios',
    '#default_value' => variable_get('socialloginandsocialshare_share_horizontal_images', 0),
    '#attributes' => array('class' => 'socialloginandsocialshare_share_horizontal_images'),
    '#options' => array(
      0 => '<img src="' . $base_url . '/' . $my_path . '/images/horizonSharing32.png"></img>',
      1 => '<img src="' . $base_url . '/' . $my_path . '/images/horizonSharing16.png" style="margin-top: 12px;"></img>',
      2 => '<img src="' . $base_url . '/' . $my_path . '/images/single-image-theme-large.png" style="margin-top: 7px;"></img>',
      3 => '<img src="' . $base_url . '/' . $my_path . '/images/single-image-theme-small.png" style="margin-top: 12px;"></img>',
      8 => '<img src="' . $base_url . '/' . $my_path . '/images/horizontalvertical.png" style="margin-top: -8px;margin-left: -1px;"></img>',
      9 => '<img src="' . $base_url . '/' . $my_path . '/images/horizontal.png" style="margin-top: 2px;margin-left: -4px;"></img>',
    ),
  );
  $form[$group]['socialloginandsocialshare_share_vertical_images'] = array(
    '#type' => 'radios',
    '#attributes' => array('class' => 'socialloginandsocialshare_share_vertical_images'),
    '#default_value' => variable_get('socialloginandsocialshare_share_vertical_images', 4),
    '#options' => array(
      4 => '<img src="' . $base_url . '/' . $my_path . '/images/32VerticlewithBox.png"></img>',
      5 => '<img id="VerticlewithBox" src="' . $base_url . '/' . $my_path . '/images/16VerticlewithBox.png" style="margin-left: 8px;"></img>',
      6 => '<img src="' . $base_url . '/' . $my_path . '/images/hybrid-verticle-vertical.png" style="margin-left: -6px;"></img>',
      7 => '<img id="hybrid-verticle-horizontal"  src="' . $base_url . '/' . $my_path . '/images/hybrid-verticle-horizontal.png" style="margin-left: -1px;"></img>',
    ),
  );
  $form[$group]['socialloginandsocialshare_show_horizotal'] = array(
    '#type' => 'hidden',
    '#suffix' => '<div id="socialloginandsocialshare_show_horizotal_widget">',
  );
  $counter_providers = variable_get('socialcounter_rearrange_providers_list', '');
  if (empty($counter_providers)) {
    variable_set('socialcounter_rearrange_providers_list', array(
      "0" => "Facebook Like",
      "1" => "Google+ +1",
      "2" => "Pinterest Pin it",
      "3" => "LinkedIn Share",
      "4" => "Facebook Send",
    ));
  }
  $form[$group]['socialshare_counter_show_providers_list'] = array(
    '#type' => 'item',
    '#id' => 'socialcounter_show_providers_list',
    '#class' => 'form-item form-type-checkboxes form-item-socialshare-counter-show-providers-list',
    '#title' => t('What sharing networks do you want to show in the sharing widget? (All other sharing networks will be shown as part of LoginRadius sharing icon)'),
    '#default_value' => variable_get('socialcounter_rearrange_providers_list', ''),
    '#suffix' => '<div id="socialcounter_hidden_field" style="display:none;">',
  );
  foreach (variable_get("socialcounter_rearrange_providers_list", '') as $provider) {
    if (!empty($provider)) {
      $raw = $provider;
      $provider = str_replace(' ', '', $provider);
      $provider = str_replace("++", "plusplus", $provider);
      $provider = str_replace("+", "plus", $provider);
      $form[$group][$provider] = array(
        '#type' => 'markup',
        '#attributes' => array('class' => array('lrshare_' . $provider)),
        '#value' => '<input type = "hidden" id = "input-lrcounter-' . $provider . '" name = "socialcounter_rearrange_providers_list[]" value = "' . $raw . '" />',
      );
    }
  }
  $share_providers = variable_get('socialloginandsocialshare_rearrange_providers_list', '');
  if (empty($share_providers)) {
    variable_set('socialloginandsocialshare_rearrange_providers_list', array(
      "0" => "facebook",
      "1" => "googleplus",
      "2" => "google",
      "3" => "pinterest",
      "4" => "twitter",
    ));
  }
  $form[$group]['socialshare_show_providers_list'] = array(
    '#type' => 'item',
    '#name' => 'socialshare_show_providers_list',
    '#id' => 'socialshare_providers_list',
    '#title' => t('What Sharing Networks do you want to show in the sharing widget? (All other sharing networks will be shown as part of LoginRadius sharing icon)'),
    '#default_value' => variable_get('socialloginandsocialshare_rearrange_providers_list', ''),
    '#prefix' => '</div><div id="loginRadiusSharingLimit" style="color:red; display:none; margin-bottom: 5px;">' . t('You can select only 9 providers.') . '</div>',
    '#suffix' => '<div id="rearrange_sharing_text"><b>' . t('What sharing network order do you prefer for your sharing widget? Drag the icons around to set the order') . '</b></div><ul id="socialloginandsocialshare_rearrange_providers" class="socialloginandsocialshare_rearrange_providers">'
  );
  foreach (variable_get('socialloginandsocialshare_rearrange_providers_list', '') as $provider) {
    if (!empty($provider)) {
      $form[$group]['lrshare_iconsprite32' . $provider] = array(
        '#type' => 'markup',
        '#attributes' => array('class' => array('lrshare_' . $provider)),
        '#value' => '<li id = "edit-lrshare-iconsprite32' . $provider . '" class = "lrshare_iconsprite32 lrshare_' . $provider . '" title = "' . $provider . '" >
	    <input type = "hidden" id = "input-lrshare-' . $provider . '" name = "socialloginandsocialshare_rearrange_providers_list[]" value = "' . $provider . '" /></li>',
      );
    }
  }
  $form[$group]['socialloginandsocialshare_rearran_providers_list'] = array(
    '#type' => 'hidden',
    '#prefix' => '</ul><div id="socialloginandsocialshare_question"></div>',
    '#suffix' => '</div>',
  );
  $form[$group]['socialloginandsocialshare_show_veritical'] = array(
    '#type' => 'hidden',
    '#suffix' => '<div id="socialloginandsocialshare_show_veritcal_widget">',
  );
  $counter_providers = variable_get('socialcounter_vertical_rearrange_providers_list', '');
  if (empty($counter_providers)) {
    variable_set('socialcounter_vertical_rearrange_providers_list', array(
      "0" => "Facebook Like",
      "1" => "Google+ +1",
      "2" => "Pinterest Pin it",
      "3" => "LinkedIn Share",
      "4" => "Facebook Send",
    ));
  }
  $form[$group]['socialshare_counter_vertical_show_providers_list'] = array(
    '#type' => 'item',
    '#id' => 'socialcounter_vertical_show_providers_list',
    '#title' => t('What Sharing Networks do you want to show in the sharing widget? (All other sharing networks will be shown as part of LoginRadius sharing icon)'),
    '#default_value' => variable_get('socialcounter_vertical_rearrange_providers_list', ''),
    '#suffix' => '<div id="socialcounter_vertical_hidden_field" style="display:none;">',
  );
  foreach (variable_get("socialcounter_vertical_rearrange_providers_list", "") as $provider) {
    if (!empty($provider)) {
      $raw = $provider;
      $provider = str_replace(' ', '', $provider);
      $provider = str_replace("++", "plusplus", $provider);
      $provider = str_replace("+", "plus", $provider);
      $form[$group]['lrshare_vertical_' . $provider] = array(
        '#type' => 'markup',
        '#attributes' => array('class' => array('lrshare_vertical_' . $provider)),
        '#value' => '<input type = "hidden" id = "input-lrcounter-vertical-' . $provider . '" name = "socialcounter_vertical_rearrange_providers_list[]" value = "' . $raw . '" />',
      );
    }
  }
  $share_providers = variable_get("socialshare_vertical_rearrange_providers_list", "");
  if (empty($share_providers)) {
    variable_set('socialshare_vertical_rearrange_providers_list', array(
      "0" => "facebook",
      "1" => "googleplus",
      "2" => "google",
      "3" => "pinterest",
      "4" => "twitter",
    ));
  }
  $form[$group]['socialshare_vetical_show_providers_list'] = array(
    '#type' => 'item',
    '#id' => 'socialshare_vetical_show_providers_list',
    '#title' => t('What Sharing Networks do you want to show in the sharing widget? (All other sharing networks will be shown as part of LoginRadius sharing icon)'),
    '#default_value' => variable_get('socialshare_vertical_rearrange_providers_list', ''),
    '#prefix' => '</div><div id="loginRadiusSharingLimit_vertical" style="color:red; display:none; margin-bottom: 5px;">' . t('You can select only 9 providers.') . '</div>',
    '#suffix' => '<div id="rearrange_sharing_text_vertical"><b>' . t('What sharing network order do you prefer for your sharing widget?(Drag around to set the order)') . '</b></div><ul id="socialshare_vertical_rearrange_providers" class="socialshare_vertical_rearrange_providers">',
  );
  foreach (variable_get("socialshare_vertical_rearrange_providers_list", "") as $provider) {
    if (!empty($provider)) {
      $form[$group]['lrshare_iconsprite32_vertical' . $provider] = array(
        '#type' => 'markup',
        '#attributes' => array('class' => array('lrshare_' . $provider)),
        '#value' => '<li id = "edit-lrshare-iconsprite32_vertical' . $provider . '" class = "lrshare_iconsprite32 lrshare_' . $provider . '" title = "' . $provider . '" >
	    <input type = "hidden" id = "input-lrshare-vertical-' . $provider . '" name = "socialshare_vertical_rearrange_providers_list[]" value = "' . $provider . '" /></li>',
      );
    }
  }
  $form[$group]['socialshare_vertical_rearra_providers_list'] = array(
    '#type' => 'hidden',
    '#prefix' => '</ul><div id="socialloginandsocialshare_question"></div>',
    '#suffix' => '</div>',
  );
  $form[$group]['socialloginandsocialshare_share_vertical_images']['socialshare_vertical_position'] = array(
    '#type' => 'radios',
    '#title' => t('Select the position of Social Sharing widget'),
    '#weight' => 50,
    '#attributes' => array(
      'class' => 'socialshare_vertical_position', // change to just 'text' for Drupal 6
    ),
    '#id' => 'socialshare_vertical_position',
    '#default_value' => variable_get('socialshare_vertical_position', 0),
    '#options' => array(
      0 => t('Top Left'),
      1 => t('Top Right'),
      2 => t('Bottom Left'),
      3 => t('Bottom Right'),
    ),
  );
  $form[$group]['socialshare_position_top'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show at the top of content.'),
    '#default_value' => variable_get('socialshare_position_top', 1) ? 1 : 0,
    '#prefix' => '<div style="clear:both"> <b>Select the position of the Social Sharing interface</b>',
    '#suffix' => '</div>',
  );
  $form[$group]['socialshare_position_bottom'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show at the bottom of content.'),
    '#default_value' => variable_get('socialshare_position_bottom', 1) ? 1 : 0,
  );
  $form[$group]['socialshare_show_pages'] = array(
    '#type' => 'radios',
    '#title' => t('Show Social Share on specific pages'),
    '#default_value' => variable_get('socialshare_show_pages', 0),
    '#options' => array(
      0 => t('All pages except those listed'),
      1 => t('Only the listed pages'),
    ),
  );
  $form[$group]['socialshare_show_exceptpages'] = array(
    '#type' => 'textarea',
    '#default_value' => variable_get('socialshare_show_exceptpages', ''),
    '#description' => t('Enter the page title(s) (in the same format provided during page creation) or node ID (if url is http://example.com/node/1 then enter 1) separated by commas'),
    '#rows' => 5,
  );
  $form[$group]['socialshare_vertical_show_pages'] = array(
    '#type' => 'radios',
    '#title' => t('Show Social Share on specific pages'),
    '#prefix' => '<div style="clear:both"></div>',
    '#default_value' => variable_get('socialshare_vertical_show_pages', 0),
    '#options' => array(
      0 => t('All pages except those listed'),
      1 => t('Only the listed pages'),
    ),
  );
  $form[$group]['socialshare_vertical_show_exceptpages'] = array(
    '#type' => 'textarea',
    '#default_value' => variable_get('socialshare_vertical_show_exceptpages', ''),
    '#description' => t('Enter the page title(s) (in the same format provided during page creation) or node ID (if url is http://example.com/node/1 then enter 1) separated by commas'),
    '#rows' => 5,
    '#suffix' => '</div>',
  );
  $form['#submit'][] = 'socialloginandsocialshare_sharebar_settings_submit';
  $form['actions']['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Save configuration'),
  );

  return $form;
}

/**
 * Submit the Social share settings.
 */
function socialloginandsocialshare_sharebar_settings_submit($form, &$form_state) {
  if (isset($form_state['clicked_button']['#post']['socialloginandsocialshare_rearrange_providers_list'])) {
    variable_set('socialloginandsocialshare_rearrange_providers_list', array_filter($form_state['clicked_button']['#post']['socialloginandsocialshare_rearrange_providers_list']));
  }
  else {
    variable_set('socialloginandsocialshare_rearrange_providers_list', array(
      "0" => "facebook",
      "1" => "googleplus",
      "2" => "google",
      "3" => "pinterest",
      "4" => "twitter",
    ));
  }
  if (!empty($form_state['clicked_button']['#post']['socialcounter_rearrange_providers_list'])) {
    variable_set('socialcounter_rearrange_providers_list', array_filter($form_state['clicked_button']['#post']['socialcounter_rearrange_providers_list']));
  }
  else {
    variable_set('socialcounter_rearrange_providers_list', array(
      "0" => "Facebook Like",
      "1" => "Google+ +1",
      "2" => "Pinterest Pin it",
      "3" => "LinkedIn Share",
      "4" => "Facebook Send",
    ));
  }
  if (isset($form_state['clicked_button']['#post']['socialshare_vertical_rearrange_providers_list'])) {
    variable_set('socialshare_vertical_rearrange_providers_list', array_filter($form_state['clicked_button']['#post']['socialshare_vertical_rearrange_providers_list']));
  }
  else {
    variable_set('socialshare_vertical_rearrange_providers_list', array(
      "0" => "facebook",
      "1" => "googleplus",
      "2" => "google",
      "3" => "pinterest",
      "4" => "twitter",
    ));
  }
  if (!empty($form_state['clicked_button']['#post']['socialcounter_vertical_rearrange_providers_list'])) {
    variable_set('socialcounter_vertical_rearrange_providers_list', array_filter($form_state['clicked_button']['#post']['socialcounter_vertical_rearrange_providers_list']));
  }
  else {
    variable_set('socialcounter_vertical_rearrange_providers_list', array(
      "0" => "Facebook Like",
      "1" => "Google+ +1",
      "2" => "Pinterest Pin it",
      "3" => "LinkedIn Share",
      "4" => "Facebook Send",
    ));
  }

  foreach ($form_state['values'] as $key => $value) {
    if (is_array($value) && isset($form_state['values']['array_filter'])) {
      $value = array_keys(array_filter($value));
    }
    variable_set($key, $value);
  }
  drupal_set_message(t('The configuration options have been saved.'));
  // Clear the cached pages and blocks.
  cache_clear_all();
  menu_rebuild();
}

/**
 * Function that validate socialloginandsocialshare apikey and secret.
 */
function socialloginandsocialshare_isvalid_apikey($apikey) {
  return preg_match('/^\{?[A-Z0-9]{8}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{12}\}?$/i', $apikey);
}

function loginradius_get_auth($apikey, $apisecret, $api_handler) {
  if (isset($apikey)) {
    $obj_auth = new LoginRadius();
    $apikey = trim($apikey);
    $apisecret = trim($apisecret);
    $validateurl = "https://hub.loginradius.com/ping/$apikey/$apisecret";
    $response = $obj_auth->loginradius_call_api($validateurl, FALSE, $api_handler);
    $response = json_decode($response);
    if (isset($response->ok)) {
      return "connection working";
    }
    elseif ($response == "service connection timeout") {
      return "service connection timeout";
    }
    elseif ($response == "timeout") {
      return "timeout";
    }
    else {
      return "connection error";
    }
  }
}

/**
 * Implements help tab  for the socialloginandsocialshare module.
 */
function socialloginandsocialshare_user_help() {
  global $base_url;
  $my_path = drupal_get_path('module', 'socialloginandsocialshare');
  drupal_add_css(drupal_get_path('module', 'socialloginandsocialshare') . '/socialloginandsocialshare.admin.css');
  $sociallogin_get_updates = t('To receive updates on new features, releases, etc. Please connect to one of our social media pages:-<br/><br/>
   <div>
   <a  href="https://www.facebook.com/loginradius" target="_blank"><img src="' . $base_url . '/' . $my_path . '/images/footer-media-links/facebook.png" /></a>
   <a href="https://twitter.com/LoginRadius" target="_blank"><img src="' . $base_url . '/' . $my_path . '/images/footer-media-links/twitter.png" /></a>
  <a href="https://plus.google.com/+Loginradius" target="_blank"> <img src="' . $base_url . '/' . $my_path . '/images/footer-media-links/google.png" /></a>
  <a href="http://www.linkedin.com/company/loginradius" target="_blank"> <img src="' . $base_url . '/' . $my_path . '/images/footer-media-links/linkedin.png" /></a>
  <a href="https://www.youtube.com/user/LoginRadius" target="_blank"> <img src="' . $base_url . '/' . $my_path . '/images/footer-media-links/youtube.png" /></a>
   </div>
');
  $support_text = t('If you liked our FREE open-source plugin, please send your feedback/testimonial to <a href="@feedback">feedback@loginradius.com</a>!', array('@feedback' => 'mailto:feedback@loginradius.com'));
  $output = '';
  $output .= '<h3>' . t('Help & Documentations') . '</h3>';
  $imptitle = t('Important links');
  $items = array(
    l(t('Plugin Installation, Configuration and Troubleshooting'), 'http://ish.re/AEFU', $options = array('attributes' => array('target' => '_blank'))),
    l(t('How to get LoginRadius API Key & Secret'), 'http://ish.re/9VBI', $options = array('attributes' => array('target' => '_blank'))),
    l(t('Discussion Forum'), 'http://ish.re/8PG2', $options = array('attributes' => array('target' => '_blank'))),
    l(t('About LoginRadius'), 'http://ish.re/96M7', $options = array('attributes' => array('target' => '_blank'))),
    l(t('LoginRadius Products'), 'http://ish.re/96M9', $options = array('attributes' => array('target' => '_blank'))),
    l(t('Social Plugins'), 'http://ish.re/96M8', $options = array('attributes' => array('target' => '_blank'))),
    l(t('Social SDKs'), 'http://ish.re/96MA', $options = array('attributes' => array('target' => '_blank'))),
  );
  $output .= theme('item_list', $items, $imptitle);
  $title = t('Get Updates');
  $items = array(
    $sociallogin_get_updates,
  );
  $output .= theme('item_list', $items, $title);
  $supporttitle = t('<div style="clear:both;"></div>Support Us');
  $item = array(
    $support_text,
  );
  $output .= theme('item_list', $item, $supporttitle);
  return $output;
}